/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.impersonation;

import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.MaprAuthenticationUtils;
import io.confluent.rest.impersonation.ImpersonatedExecutor;
import java.security.PrivilegedAction;

public class ImpersonationUtils {
    private static final ImpersonatedExecutor EXECUTOR = new ImpersonatedExecutor();
    private static boolean isImpersonationEnabled;

    public static boolean isImpersonationEnabled() {
        return isImpersonationEnabled;
    }

    public static void initialize(RestConfig config) {
        isImpersonationEnabled = config.getBoolean("impersonation.enable");
    }

    public static <T> T runAsUserIfImpersonationEnabled(PrivilegedAction<T> action, String auth, String cookie) {
        if (isImpersonationEnabled) {
            return ImpersonationUtils.runAsUser(action, auth, cookie);
        }
        return action.run();
    }

    public static ImpersonatedExecutor executor() {
        return EXECUTOR;
    }

    public static <T> T runAsUser(PrivilegedAction<T> action, String auth, String cookie) {
        String username = MaprAuthenticationUtils.getUserNameFromAuthenticationOrCookie(auth, cookie);
        return ImpersonationUtils.executor().runAs(username, action);
    }
}

