/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.util;

import com.google.common.collect.ImmutableMap;
import io.confluent.rest.util.HeadersFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;

public class HeadersFilterTest
extends EasyMockSupport {
    private HeadersFilter filter;
    private FilterConfig config;

    @Before
    public void setUp() {
        this.filter = new HeadersFilter();
        this.config = (FilterConfig)this.mock(FilterConfig.class);
    }

    @Test
    public void onInitFailOnNonExistingFile() {
        EasyMock.expect((Object)this.config.getInitParameter("headers.file")).andReturn((Object)"non-existent");
        this.replayAll();
        io.confluent.rest.mapr.test.TestUtils.assertThatThrownException(() -> this.filter.init(this.config), (Matcher<Exception>)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(ServletException.class), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(FileNotFoundException.class))));
        this.verifyAll();
    }

    @Test
    public void onInitWrapIOExceptions() throws Exception {
        File wrongFormattedFile = TestUtils.tempFile();
        FileUtils.writeStringToFile((File)wrongFormattedFile, (String)"Some incorrect data");
        EasyMock.expect((Object)this.config.getInitParameter("headers.file")).andReturn((Object)wrongFormattedFile.getPath());
        this.replayAll();
        io.confluent.rest.mapr.test.TestUtils.assertThatThrownException(() -> this.filter.init(this.config), (Matcher<Exception>)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(ServletException.class), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(IOException.class))));
        this.verifyAll();
    }

    @Test
    public void onFilterWithoutInitPassesChain() throws Exception {
        ServletRequest servletRequest = (ServletRequest)this.mock(ServletRequest.class);
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)this.mock(FilterChain.class);
        filterChain.doFilter(servletRequest, (ServletResponse)httpServletResponse);
        EasyMock.expectLastCall();
        this.replayAll();
        this.filter.doFilter(servletRequest, (ServletResponse)httpServletResponse, filterChain);
        this.verifyAll();
    }

    @Test
    public void onFilterWithoutNewHeadersPassesChain() throws Exception {
        ServletRequest servletRequest = (ServletRequest)this.mock(ServletRequest.class);
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)this.mock(FilterChain.class);
        EasyMock.expect((Object)this.config.getInitParameter("headers.file")).andReturn((Object)this.pathToXmlFileWithProperties((Map<String, String>)ImmutableMap.of()));
        filterChain.doFilter(servletRequest, (ServletResponse)httpServletResponse);
        EasyMock.expectLastCall();
        this.replayAll();
        this.filter.init(this.config);
        this.filter.doFilter(servletRequest, (ServletResponse)httpServletResponse, filterChain);
        this.verifyAll();
    }

    @Test
    public void onFilterAppendsHeaders() throws Exception {
        ServletRequest servletRequest = (ServletRequest)this.mock(ServletRequest.class);
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.mock(HttpServletResponse.class);
        ImmutableMap headers = ImmutableMap.of((Object)"string-header", (Object)"text", (Object)"number-header", (Object)"1232", (Object)"multivalued-header", (Object)"value1; key=value");
        EasyMock.expect((Object)this.config.getInitParameter("headers.file")).andReturn((Object)this.pathToXmlFileWithProperties((Map<String, String>)headers));
        FilterChain filterChain = (FilterChain)this.mock(FilterChain.class);
        filterChain.doFilter(servletRequest, (ServletResponse)httpServletResponse);
        EasyMock.expectLastCall();
        headers.forEach((name, value) -> {
            httpServletResponse.addHeader(name, value);
            EasyMock.expectLastCall();
        });
        this.replayAll();
        this.filter.init(this.config);
        this.filter.doFilter(servletRequest, (ServletResponse)httpServletResponse, filterChain);
        this.verifyAll();
    }

    @Test
    public void onDestroyDoesNothing() throws Exception {
        EasyMock.expect((Object)this.config.getInitParameter("headers.file")).andReturn((Object)this.pathToXmlFileWithProperties((Map<String, String>)ImmutableMap.of()));
        this.replayAll();
        this.filter.init(this.config);
        this.filter.destroy();
        this.verifyAll();
    }

    private String pathToXmlFileWithProperties(Map<String, String> headers) throws Exception {
        File file = TestUtils.tempFile();
        try (FileOutputStream outputStream = FileUtils.openOutputStream((File)file);){
            Properties props = new Properties();
            props.putAll(headers);
            props.storeToXML(outputStream, "any comments");
        }
        return file.getPath();
    }
}

