/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.KafkaExceptionMapper;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.Response;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ConcurrentTransactionsException;
import org.apache.kafka.common.errors.DelegationTokenAuthorizationException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.TransactionalIdAuthorizationException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KafkaExceptionMapperTest {
    private KafkaExceptionMapper exceptionMapper;

    @Before
    public void setUp() {
        this.exceptionMapper = new KafkaExceptionMapper(null);
    }

    @Test
    public void testAuthenticationExceptions() {
        this.verifyMapperResponse((Throwable)new AuthenticationException("some message"), Response.Status.UNAUTHORIZED, 40101);
        this.verifyMapperResponse((Throwable)new SaslAuthenticationException("some message"), Response.Status.UNAUTHORIZED, 40101);
    }

    @Test
    public void testAuthorizationExceptions() {
        this.verifyMapperResponse((Throwable)new AuthorizationException("some message"), Response.Status.FORBIDDEN, 40301);
        this.verifyMapperResponse((Throwable)new ClusterAuthorizationException("some message"), Response.Status.FORBIDDEN, 40301);
        this.verifyMapperResponse((Throwable)new DelegationTokenAuthorizationException("some message"), Response.Status.FORBIDDEN, 40301);
        this.verifyMapperResponse((Throwable)new GroupAuthorizationException("some message"), Response.Status.FORBIDDEN, 40301);
        this.verifyMapperResponse((Throwable)new TopicAuthorizationException("some message"), Response.Status.FORBIDDEN, 40301);
        this.verifyMapperResponse((Throwable)new TransactionalIdAuthorizationException("some message"), Response.Status.FORBIDDEN, 40301);
    }

    @Test
    public void testKafkaExceptions() {
        this.verifyMapperResponse((Throwable)new BrokerNotAvailableException("some message"), Response.Status.SERVICE_UNAVAILABLE, 50302);
        this.verifyMapperResponse((Throwable)new InvalidReplicationFactorException("some message"), Response.Status.BAD_REQUEST, 40002);
        this.verifyMapperResponse((Throwable)new SecurityDisabledException("some message"), Response.Status.BAD_REQUEST, 40002);
        this.verifyMapperResponse((Throwable)new UnsupportedVersionException("some message"), Response.Status.BAD_REQUEST, 40002);
        this.verifyMapperResponse((Throwable)new InvalidPartitionsException("some message"), Response.Status.BAD_REQUEST, 40002);
        this.verifyMapperResponse((Throwable)new InvalidRequestException("some message"), Response.Status.BAD_REQUEST, 40002);
        this.verifyMapperResponse((Throwable)new UnknownServerException("some message"), Response.Status.BAD_REQUEST, 40002);
        this.verifyMapperResponse((Throwable)new UnknownTopicOrPartitionException("some message"), Response.Status.NOT_FOUND, 40403);
        this.verifyMapperResponse((Throwable)new PolicyViolationException("some message"), Response.Status.BAD_REQUEST, 40002);
        this.verifyMapperResponse((Throwable)new TopicExistsException("some message"), Response.Status.BAD_REQUEST, 40002);
        this.verifyMapperResponse((Throwable)new InvalidConfigurationException("some message"), Response.Status.BAD_REQUEST, 40002);
        this.verifyMapperResponse((Throwable)new NotCoordinatorException("some message"), Response.Status.INTERNAL_SERVER_ERROR, 50003);
        this.verifyMapperResponse((Throwable)new NotEnoughReplicasException("some message"), Response.Status.INTERNAL_SERVER_ERROR, 50003);
        this.verifyMapperResponse((Throwable)new CommitFailedException(), Response.Status.INTERNAL_SERVER_ERROR, 50002);
        this.verifyMapperResponse((Throwable)new ConcurrentTransactionsException("some message"), Response.Status.INTERNAL_SERVER_ERROR, 50002);
        this.verifyMapperResponse(new NullPointerException("some message"), Response.Status.INTERNAL_SERVER_ERROR, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        this.verifyMapperResponse(new IllegalArgumentException("some message"), Response.Status.INTERNAL_SERVER_ERROR, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }

    private void verifyMapperResponse(Throwable throwable, Response.Status status, int errorCode) {
        Response response = this.exceptionMapper.toResponse((Throwable)new ExecutionException("whats this then", throwable));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)status.getStatusCode(), (long)response.getStatus());
        ErrorMessage errorMessage = (ErrorMessage)response.getEntity();
        Assert.assertEquals((long)errorCode, (long)errorMessage.getErrorCode());
    }
}

