/**
 * Copyright 2019 Confluent Inc.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.confluent.rest;

import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityManager;

/**
 * Read property from /MAPR_HOME/ssl-client.xml
 */
public class KafkaRestSslPropertiesReader {

  /**
   * Reads client keystore location.
   * @return client keystore location as string
   */
  public static String getClientKeystoreLocation() {
    try (SslConfig sslConfig = WebSecurityManager
            .getSslConfig(SslConfig.SslConfigScope.SCOPE_CLIENT_ONLY)) {
      return sslConfig.getClientKeystoreLocation();
    }
  }

  /**
   * Reads client keystore password value.
   * @return client keystore password value as string
   */
  public static String getServerKeystorePassword() {
    try (SslConfig sslConfig = WebSecurityManager
            .getSslConfig()) {
      return new String(sslConfig.getServerKeystorePassword());
    }
  }

  /**
   * Reads client key password value.
   * @return client key password value as string
   */
  public static String getServerKeyPassword() {
    try (SslConfig sslConfig = WebSecurityManager
            .getSslConfig()) {
      return new String(sslConfig.getServerKeyPassword());
    }
  }
}
