/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.impersonation;

import io.confluent.rest.exceptions.RestException;
import io.confluent.rest.exceptions.RestNotAuthorizedException;
import io.confluent.rest.exceptions.RestServerErrorException;
import javax.ws.rs.core.Response;

public class Errors {
    private static final int ERROR_CODE = RestServerErrorException.DEFAULT_ERROR_CODE;
    private static final int DEFAULT_ERROR_CODE = Response.Status.SERVICE_UNAVAILABLE.getStatusCode();

    public static RestException maprTicketDecryptException(String message) {
        return new RestNotAuthorizedException(message, ERROR_CODE);
    }

    public static RestException maprTicketDecryptException(String message, Throwable cause) {
        return new RestNotAuthorizedException(message, ERROR_CODE, cause);
    }

    public static RestServerErrorException serverLoginException(Throwable cause) {
        return new RestServerErrorException("Login fails", DEFAULT_ERROR_CODE, cause);
    }

    public static RestServerErrorException serverLoginException(String message, Throwable cause) {
        return new RestServerErrorException(message, DEFAULT_ERROR_CODE, cause);
    }
}

