/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StaticResourcesTest {
    TestRestConfig config;
    StaticApplication app;
    String staticContent;

    @Before
    public void setUp() throws Exception {
        try (InputStreamReader isr = new InputStreamReader(ClassLoader.getSystemResourceAsStream("static/index.html"), StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            this.staticContent = br.readLine() + System.lineSeparator();
        }
        Properties props = new Properties();
        props.setProperty("debug", "false");
        this.config = TestRestConfig.maprCompatible(props);
        this.app = new StaticApplication(this.config);
        this.app.start();
    }

    @After
    public void tearDown() throws Exception {
        this.app.stop();
        this.app.join();
    }

    @Test
    public void testStaticContent() throws Exception {
        this.testGet("/index.html", 200, this.staticContent);
    }

    @Test
    public void testDefaultServletMapsToIndex() throws Exception {
        this.testGet("/", 200, this.staticContent);
    }

    @Test
    public void testDynamic() throws Exception {
        this.testGet("/dynamic", 200, "it works");
    }

    private void testGet(String path, int expectedStatus, String expectedMessage) {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target("http://localhost:" + this.config.getInt("port")).path(path).request().get();
        Assert.assertEquals((long)expectedStatus, (long)response.getStatus());
        Assert.assertEquals((Object)expectedMessage, (Object)response.readEntity(String.class));
    }

    @Produces(value={"application/json"})
    @Path(value="/")
    public static class DynamicResource {
        @GET
        @Path(value="/dynamic")
        public String dynamic() {
            return "it works";
        }
    }

    private static class StaticApplication
    extends Application<TestRestConfig> {
        Configurable resourceConfig;

        StaticApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            this.resourceConfig = config;
            config.register(DynamicResource.class);
            config.property("jersey.config.servlet.filter.staticContentRegex", (Object)"/(index\\.html|)");
        }

        protected ResourceCollection getStaticResources() {
            return new ResourceCollection(new Resource[]{Resource.newClassPathResource((String)"static")});
        }
    }
}

