/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import io.confluent.common.config.ConfigException;
import io.confluent.common.config.types.Password;
import io.confluent.common.metrics.JmxReporter;
import io.confluent.common.metrics.MetricConfig;
import io.confluent.common.metrics.Metrics;
import io.confluent.common.metrics.MetricsReporter;
import io.confluent.rest.KafkaRestSSLPropertiesReader;
import io.confluent.rest.MetricsListener;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import io.confluent.rest.exceptions.ConstraintViolationExceptionMapper;
import io.confluent.rest.exceptions.GenericExceptionMapper;
import io.confluent.rest.exceptions.WebApplicationExceptionMapper;
import io.confluent.rest.extension.ResourceExtension;
import io.confluent.rest.impersonation.ImpersonationUtils;
import io.confluent.rest.metrics.MetricsResourceMethodApplicationListener;
import io.confluent.rest.util.HeadersFilter;
import io.confluent.rest.util.NotAllowedMethodFilter;
import io.confluent.rest.validation.JacksonMessageBodyProvider;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.ws.rs.core.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.validation.ValidationFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Application<T extends RestConfig> {
    protected T config;
    protected Server server = null;
    protected CountDownLatch shutdownLatch = new CountDownLatch(1);
    protected Metrics metrics;
    protected final Slf4jRequestLog requestLog;
    protected final List<ResourceExtension> resourceExtensions = new ArrayList<ResourceExtension>();
    protected SslContextFactory sslContextFactory;
    private static final Logger log = LoggerFactory.getLogger(Application.class);

    public Application(T config) {
        this.config = config;
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS);
        List reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        reporters.add(new JmxReporter(config.getString("metrics.jmx.prefix")));
        this.metrics = new Metrics(metricConfig, reporters, ((RestConfig)((Object)config)).getTime());
        this.requestLog = new Slf4jRequestLog();
        this.requestLog.setLoggerName(config.getString("request.logger.name"));
        this.requestLog.setLogLatency(true);
        this.sslContextFactory = this.createSslContextFactory();
        ImpersonationUtils.initialize(config);
    }

    public abstract void setupResources(Configurable<?> var1, T var2);

    protected ResourceCollection getStaticResources() {
        return null;
    }

    protected void configurePreResourceHandling(ServletContextHandler context) {
    }

    protected SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    protected void configurePostResourceHandling(ServletContextHandler context) {
    }

    protected void configureWebSocketPostResourceHandling(ServletContextHandler context) {
    }

    public Map<String, String> getMetricsTags() {
        return new LinkedHashMap<String, String>();
    }

    public Server createServer() throws ServletException {
        ResourceConfig resourceConfig = new ResourceConfig();
        Map configuredTags = this.getConfiguration().getMap("metrics.tag.map");
        HashMap<String, String> combinedMetricsTags = new HashMap<String, String>(this.getMetricsTags());
        combinedMetricsTags.putAll(configuredTags);
        this.configureBaseApplication((Configurable<?>)resourceConfig, (Map<String, String>)combinedMetricsTags);
        this.configureResourceExtensions(resourceConfig);
        this.setupResources((Configurable<?>)resourceConfig, this.getConfiguration());
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        FilterHolder servletHolder = new FilterHolder((Filter)servletContainer);
        this.server = new Server(){

            protected void doStop() throws Exception {
                super.doStop();
                Application.this.metrics.close();
                Application.this.doShutdown();
                Application.this.shutdownLatch.countDown();
            }
        };
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.server.addEventListener((Container.Listener)mbContainer);
        this.server.addBean((Object)mbContainer);
        MetricsListener metricsListener = new MetricsListener(this.metrics, "jetty", combinedMetricsTags);
        List<URI> listeners = Application.parseListeners(this.config.getList("listeners"), this.config.getInt("port"), Arrays.asList("http", "https"), "http");
        for (URI listener : listeners) {
            log.info("Adding listener: " + listener.toString());
            NetworkTrafficServerConnector connector = listener.getScheme().equals("http") ? new NetworkTrafficServerConnector(this.server) : new NetworkTrafficServerConnector(this.server, this.sslContextFactory);
            for (ConnectionFactory cf : connector.getConnectionFactories()) {
                if (!(cf instanceof HttpConnectionFactory)) continue;
                ((HttpConnectionFactory)cf).getHttpConfiguration().setSendServerVersion(false);
            }
            connector.addNetworkTrafficListener((NetworkTrafficListener)metricsListener);
            connector.setPort(listener.getPort());
            connector.setHost(listener.getHost());
            this.server.addConnector((Connector)connector);
        }
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        ServletHolder defaultHolder = new ServletHolder("default", DefaultServlet.class);
        defaultHolder.setInitParameter("dirAllowed", "false");
        ResourceCollection staticResources = this.getStaticResources();
        if (staticResources != null) {
            context.setBaseResource((Resource)staticResources);
        }
        this.configureSecurityHandler(context);
        this.configureCustomAndSecurityHeaders(context);
        if (this.isCorsEnabled()) {
            String allowedOrigins = this.config.getString("access.control.allow.origin");
            FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
            filterHolder.setName("cross-origin");
            filterHolder.setInitParameter("allowedOrigins", allowedOrigins);
            String allowedMethods = this.config.getString("access.control.allow.methods");
            String allowedHeaders = this.config.getString("access.control.allow.headers");
            if (allowedMethods != null && !allowedMethods.trim().isEmpty()) {
                filterHolder.setInitParameter("allowedMethods", allowedMethods);
            }
            if (allowedHeaders != null && !allowedHeaders.trim().isEmpty()) {
                filterHolder.setInitParameter("allowedHeaders", allowedHeaders);
            }
            filterHolder.setInitParameter("chainPreflight", "false");
            context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        this.configurePreResourceHandling(context);
        context.addFilter(servletHolder, "/*", null);
        this.configurePostResourceHandling(context);
        context.addServlet(defaultHolder, "/*");
        this.applyCustomConfiguration(context, "rest.servlet.initializor.classes");
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)this.requestLog);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{context, new DefaultHandler(), requestLogHandler});
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        ServletContextHandler webSocketContext = new ServletContextHandler(1);
        webSocketContext.setContextPath(this.config.getString("websocket.path.prefix"));
        this.configureSecurityHandler(webSocketContext);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{statsHandler, webSocketContext});
        this.server.setHandler(this.wrapWithGzipHandler((Handler)contexts));
        ServerContainer container = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)webSocketContext);
        this.registerWebSocketEndpoints(container);
        this.configureWebSocketPostResourceHandling(webSocketContext);
        this.applyCustomConfiguration(webSocketContext, "websocket.servlet.initializor.classes");
        int gracefulShutdownMs = this.getConfiguration().getInt("shutdown.graceful.ms");
        if (gracefulShutdownMs > 0) {
            this.server.setStopTimeout((long)gracefulShutdownMs);
        }
        this.server.setStopAtShutdown(true);
        return this.server;
    }

    private boolean isCorsEnabled() {
        return AuthUtil.isCorsEnabled(this.config);
    }

    private void configureResourceExtensions(ResourceConfig resourceConfig) {
        this.resourceExtensions.addAll(this.getConfiguration().getConfiguredInstances("resource.extension.classes", ResourceExtension.class));
        this.resourceExtensions.forEach(ext -> {
            try {
                ext.register((Configurable<?>)resourceConfig, this);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception throw by resource extension. ext:" + ext, e);
            }
        });
    }

    private void applyCustomConfiguration(ServletContextHandler context, String initializerConfigName) {
        this.getConfiguration().getConfiguredInstances(initializerConfigName, Consumer.class).forEach(initializer -> {
            try {
                initializer.accept(context);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception from custom initializer. config:" + initializerConfigName + ", initializer" + initializer, e);
            }
        });
    }

    protected void configureSecurityHandler(ServletContextHandler context) {
        boolean isAuthenticationEnabled = this.config.getBoolean("authentication.enable");
        if (isAuthenticationEnabled) {
            this.addMultiAuthFilter(context);
        }
    }

    public static void disableNotAllowedHttpMethods(Configurable<?> config) {
        NotAllowedMethodFilter filter = new NotAllowedMethodFilter();
        config.register((Object)filter);
    }

    protected void configureCustomAndSecurityHeaders(ServletContextHandler context) {
        String headersFile = this.config.getString("headers.file");
        if (headersFile != null && !headersFile.isEmpty()) {
            this.addScurityAndCustomHeadersFilter(context);
        }
    }

    private void addMultiAuthFilter(ServletContextHandler context) {
        FilterHolder holder = new FilterHolder((Filter)new AuthenticationFilter());
        holder.setInitParameter("type", "org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler");
        List authenticationTypes = this.config.getList("hadoop.http.authentication.types");
        ListIterator authenticationTypesIterator = authenticationTypes.listIterator();
        while (authenticationTypesIterator.hasNext()) {
            holder.setInitParameter("type" + authenticationTypesIterator.nextIndex(), (String)authenticationTypesIterator.next());
        }
        Long cookiesExpirationTime = this.config.getLong("authentication.cookie.expiration");
        holder.setInitParameter("token.validity", cookiesExpirationTime.toString());
        context.addFilter(holder, "/*", EnumSet.allOf(DispatcherType.class));
    }

    private void addScurityAndCustomHeadersFilter(ServletContextHandler context) {
        FilterHolder holder = new FilterHolder((Filter)new HeadersFilter());
        holder.setInitParameter("headers.file", this.config.getString("headers.file"));
        context.addFilter(holder, "/*", EnumSet.allOf(DispatcherType.class));
    }

    private SslContextFactory createSslContextFactory() {
        List excludedCipherSuites;
        List cipherSuites;
        List disabledProtocols;
        SslContextFactory sslContextFactory = new SslContextFactory();
        if (!this.config.getString("ssl.keystore.location").isEmpty()) {
            sslContextFactory.setKeyStorePath(this.config.getString("ssl.keystore.location"));
        } else {
            String clusterSslKeystoreLocation = KafkaRestSSLPropertiesReader.getClientKeystoreLocation();
            if (clusterSslKeystoreLocation == null) {
                throw new ConfigException("ssl.keystore.location");
            }
            sslContextFactory.setKeyStorePath(clusterSslKeystoreLocation);
        }
        Password sslKeystorePassword = this.config.getPassword("ssl.keystore.password");
        if (!Objects.equals(sslKeystorePassword.value(), "")) {
            sslContextFactory.setKeyStorePassword(sslKeystorePassword.value());
        } else {
            String clusterSslKeystorePassword = KafkaRestSSLPropertiesReader.getClientKeystorePassword();
            if (Objects.equals(clusterSslKeystorePassword, "")) {
                throw new ConfigException("ssl.keystore.password");
            }
            sslContextFactory.setKeyStorePassword(clusterSslKeystorePassword);
        }
        Password sslKeyPassword = this.config.getPassword("ssl.key.password");
        if (!Objects.equals(sslKeyPassword.value(), "")) {
            sslContextFactory.setKeyManagerPassword(sslKeyPassword.value());
        } else {
            String clusterSslKeyPassword = KafkaRestSSLPropertiesReader.getClientKeyPassword();
            if (Objects.equals(clusterSslKeyPassword, "")) {
                throw new ConfigException("ssl.key.password");
            }
            sslContextFactory.setKeyManagerPassword(clusterSslKeyPassword);
        }
        if (!this.config.getString("ssl.keymanager.algorithm").isEmpty()) {
            sslContextFactory.setKeyManagerFactoryAlgorithm(this.config.getString("ssl.keymanager.algorithm"));
        }
        sslContextFactory.setNeedClientAuth(this.config.getBoolean("ssl.client.auth"));
        List enabledProtocols = this.config.getList("ssl.enabled.protocols");
        if (!enabledProtocols.isEmpty()) {
            sslContextFactory.setIncludeProtocols(enabledProtocols.toArray(new String[0]));
        }
        if (!(disabledProtocols = this.config.getList("ssl.disabled.protocols")).isEmpty()) {
            sslContextFactory.setExcludeProtocols(disabledProtocols.toArray(new String[0]));
        }
        if (!(cipherSuites = this.config.getList("ssl.cipher.suites")).isEmpty()) {
            sslContextFactory.setIncludeCipherSuites(cipherSuites.toArray(new String[0]));
        }
        if (!(excludedCipherSuites = this.config.getList("ssl.cipher.suites.exclude")).isEmpty()) {
            sslContextFactory.setExcludeCipherSuites(excludedCipherSuites.toArray(new String[0]));
        }
        if (!this.config.getString("ssl.endpoint.identification.algorithm").isEmpty()) {
            sslContextFactory.setEndpointIdentificationAlgorithm(this.config.getString("ssl.endpoint.identification.algorithm"));
        }
        if (!this.config.getString("ssl.truststore.location").isEmpty()) {
            sslContextFactory.setTrustStorePath(this.config.getString("ssl.truststore.location"));
            sslContextFactory.setTrustStorePassword(this.config.getPassword("ssl.truststore.password").value());
            sslContextFactory.setTrustStoreType(this.config.getString("ssl.truststore.type"));
            if (!this.config.getString("ssl.trustmanager.algorithm").isEmpty()) {
                sslContextFactory.setTrustManagerFactoryAlgorithm(this.config.getString("ssl.trustmanager.algorithm"));
            }
        }
        sslContextFactory.setProtocol(this.config.getString("ssl.protocol"));
        if (!this.config.getString("ssl.provider").isEmpty()) {
            sslContextFactory.setProtocol(this.config.getString("ssl.provider"));
        }
        sslContextFactory.setRenegotiationAllowed(false);
        return sslContextFactory;
    }

    public Handler wrapWithGzipHandler(Handler handler) {
        if (this.config.getBoolean("compression.enable")) {
            GzipHandler gzip = new GzipHandler();
            gzip.setIncludedMethods(new String[]{"GET", "POST"});
            gzip.setHandler(handler);
            return gzip;
        }
        return handler;
    }

    protected void registerWebSocketEndpoints(ServerContainer container) {
    }

    protected ConstraintSecurityHandler createBasicSecurityHandler() {
        String realm = this.getConfiguration().getString("authentication.realm");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.addConstraintMapping(this.createGlobalAuthConstraint());
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setLoginService((LoginService)new JAASLoginService(realm));
        securityHandler.setIdentityService((IdentityService)new DefaultIdentityService());
        securityHandler.setRealmName(realm);
        AuthUtil.createUnsecuredConstraints(this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        return securityHandler;
    }

    protected ConstraintMapping createGlobalAuthConstraint() {
        return AuthUtil.createGlobalAuthConstraint(this.config);
    }

    public static List<URI> parseListeners(List<String> listenersConfig, int deprecatedPort, List<String> supportedSchemes, String defaultScheme) {
        if (listenersConfig.isEmpty() || listenersConfig.get(0).isEmpty()) {
            log.warn("DEPRECATION warning: `listeners` configuration is not configured. Falling back to the deprecated `port` configuration.");
            listenersConfig = new ArrayList<String>(1);
            listenersConfig.add(defaultScheme + "://0.0.0.0:" + deprecatedPort);
        }
        ArrayList<URI> listeners = new ArrayList<URI>(listenersConfig.size());
        for (String listenerStr : listenersConfig) {
            URI uri;
            try {
                uri = new URI(listenerStr);
            }
            catch (URISyntaxException use) {
                throw new ConfigException("Could not parse a listener URI from the `listener` configuration option.");
            }
            String scheme = uri.getScheme();
            if (scheme == null) {
                throw new ConfigException("Found a listener without a scheme. All listeners must have a scheme. The listener without a scheme is: " + listenerStr);
            }
            if (uri.getPort() == -1) {
                throw new ConfigException("Found a listener without a port. All listeners must have a port. The listener without a port is: " + listenerStr);
            }
            if (!supportedSchemes.contains(scheme)) {
                log.warn("Found a listener with an unsupported scheme (supported: {}). Ignoring listener '{}'", supportedSchemes, (Object)listenerStr);
                continue;
            }
            listeners.add(uri);
        }
        if (listeners.isEmpty()) {
            throw new ConfigException("No listeners are configured. Must have at least one listener.");
        }
        return listeners;
    }

    public void configureBaseApplication(Configurable<?> config) {
        this.configureBaseApplication(config, null);
    }

    public void configureBaseApplication(Configurable<?> config, Map<String, String> metricTags) {
        T restConfig = this.getConfiguration();
        this.registerJsonProvider(config, restConfig, true);
        this.registerFeatures(config, restConfig);
        this.registerExceptionMappers(config, restConfig);
        Application.disableNotAllowedHttpMethods(config);
        config.register((Object)new MetricsResourceMethodApplicationListener(this.metrics, "jersey", metricTags, ((RestConfig)((Object)restConfig)).getTime()));
        config.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true);
        config.property("jersey.config.server.wadl.disableWadl", (Object)true);
    }

    protected void registerJsonProvider(Configurable<?> config, T restConfig, boolean registerExceptionMapper) {
        ObjectMapper jsonMapper = this.getJsonMapper();
        JacksonMessageBodyProvider jsonProvider = new JacksonMessageBodyProvider(jsonMapper);
        config.register((Object)jsonProvider);
        if (registerExceptionMapper) {
            config.register(JsonParseExceptionMapper.class);
        }
    }

    protected void registerFeatures(Configurable<?> config, T restConfig) {
        config.register(ValidationFeature.class);
    }

    protected void registerExceptionMappers(Configurable<?> config, T restConfig) {
        config.register(ConstraintViolationExceptionMapper.class);
        config.register((Object)new WebApplicationExceptionMapper((RestConfig)((Object)restConfig)));
        config.register((Object)new GenericExceptionMapper((RestConfig)((Object)restConfig)));
    }

    private static String getFromCredentialsPath(String name, String credentialsPath) {
        Method getPasswordMethod;
        try {
            getPasswordMethod = Configuration.class.getMethod("getPassword", String.class);
        }
        catch (NoSuchMethodException e) {
            getPasswordMethod = null;
        }
        Configuration hadoopConf = new Configuration();
        if (getPasswordMethod != null) {
            hadoopConf.set("hadoop.security.credential.provider.path", credentialsPath);
            try {
                char[] pass = (char[])getPasswordMethod.invoke((Object)hadoopConf, name);
                return pass == null ? "" : new String(pass);
            }
            catch (IllegalAccessException e) {
                log.error("Could not load password " + e);
                throw new IllegalArgumentException("Could not load password for [" + name + "]", e);
            }
            catch (InvocationTargetException e) {
                log.error("Could not load password " + e);
                throw new IllegalArgumentException("Could not load password for [" + name + "]", e);
            }
        }
        return "";
    }

    public T getConfiguration() {
        return this.config;
    }

    protected ObjectMapper getJsonMapper() {
        return new ObjectMapper();
    }

    public void start() throws Exception {
        if (this.server == null) {
            this.createServer();
        }
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.server.join();
        this.shutdownLatch.await();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    private void doShutdown() {
        this.resourceExtensions.forEach(ext -> {
            try {
                ext.close();
            }
            catch (IOException e) {
                log.error("Error closing the extension resource. ext:" + ext, (Throwable)e);
            }
        });
        this.onShutdown();
    }

    public void onShutdown() {
    }
}

