/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetricsResourceMethodApplicationListenerIntegrationTest {
    TestRestConfig config;
    ApplicationWithFilter app;

    @Before
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("debug", "false");
        this.config = new TestRestConfig(props);
        this.app = new ApplicationWithFilter(this.config);
        this.app.start();
    }

    @After
    public void tearDown() throws Exception {
        this.app.stop();
        this.app.join();
    }

    @Test
    public void testListenerHandlesDispatchErrorsGracefully() {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target("http://localhost:" + this.config.getInt("port")).path("/private/endpoint").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.readEntity(String.class)).contains("Resource Java method invocation error"));
    }

    @Produces(value={"application/json"})
    @Path(value="/private")
    private static class PrivateResource {
        private PrivateResource() {
        }

        @GET
        @Path(value="/endpoint")
        public Void notAccessible() {
            return null;
        }
    }

    private static class ApplicationWithFilter
    extends Application<TestRestConfig> {
        Configurable resourceConfig;

        ApplicationWithFilter(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            this.resourceConfig = config;
            config.register(PrivateResource.class);
            config.property("jersey.config.server.response.setStatusOverSendError", (Object)true);
        }
    }
}

