/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.common.metrics.KafkaMetric;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestMetricsReporter;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.annotations.PerformanceMetric;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslTest {
    private static final Logger log = LoggerFactory.getLogger(SaslTest.class);
    private File jaasFile;
    private File loginPropertiesFile;
    private String previousAuthConfig;
    private SaslTestApplication app;
    private CloseableHttpClient httpclient;
    String httpUri = "http://localhost:8080";

    @Before
    public void setUp() throws Exception {
        this.jaasFile = File.createTempFile("jaas", ".config");
        this.loginPropertiesFile = File.createTempFile("login", ".properties");
        String jaas = "c3 {\n  org.eclipse.jetty.jaas.spi.PropertyFileLoginModule required\n  debug=\"true\"\n  file=\"" + this.loginPropertiesFile.getAbsolutePath() + "\";\n};\n";
        Files.write(this.jaasFile.toPath(), jaas.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
        String loginProperties = "jay: kafka,Administrators\nneha: akfak,Administrators\njun: kafka-\n";
        Files.write(this.loginPropertiesFile.toPath(), loginProperties.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
        this.previousAuthConfig = System.getProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        System.setProperty("java.security.auth.login.config", this.jaasFile.getAbsolutePath());
        this.httpclient = HttpClients.createDefault();
        TestMetricsReporter.reset();
        Properties props = new Properties();
        props.put("listeners", this.httpUri);
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        this.configBasic(props);
        TestRestConfig config = new TestRestConfig(props);
        this.app = new SaslTestApplication(config);
        this.app.start();
    }

    @After
    public void cleanup() throws Exception {
        Configuration.setConfiguration(null);
        if (this.previousAuthConfig != null) {
            System.setProperty("java.security.auth.login.config", this.previousAuthConfig);
        }
        this.httpclient.close();
        this.app.stop();
    }

    private void configBasic(Properties props) {
        props.put("authentication.method", "BASIC");
        props.put("authentication.realm", "c3");
        props.put("authentication.roles", Arrays.asList("Administrators"));
    }

    @Test
    public void testNoAuthAttempt() throws Exception {
        HttpResponse response = this.makeGetRequest(this.httpUri + "/test");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatusLine().getStatusCode());
        this.assertMetricsCollected();
    }

    @Test
    public void testBadLoginAttempt() throws Exception {
        CloseableHttpResponse response = this.makeGetRequest(this.httpUri + "/test", "this shouldnt work");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatusLine().getStatusCode());
        this.assertMetricsCollected();
    }

    @Test
    public void testAuthorizedAttempt() throws Exception {
        try (CloseableHttpResponse response = null;){
            response = this.makeGetRequest(this.httpUri + "/principal", "bmVoYTpha2Zhaw==");
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"neha", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
            response.close();
            response = this.makeGetRequest(this.httpUri + "/role/Administrators", "bmVoYTpha2Zhaw==");
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"true", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
            response.close();
            response = this.makeGetRequest(this.httpUri + "/role/blah", "bmVoYTpha2Zhaw==");
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"false", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
            response.close();
            this.assertMetricsCollected();
        }
    }

    public void testUnauthorizedAttempt() throws Exception {
        CloseableHttpResponse response = this.makeGetRequest(this.httpUri + "/principal", "anVuOmthZmthLQ==");
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.getStatusLine().getStatusCode());
        this.assertMetricsCollected();
    }

    private void assertMetricsCollected() {
        Assert.assertNotEquals((String)"Expected to have metrics.", (long)0L, (long)TestMetricsReporter.getMetricTimeseries().size());
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            if (!metric.metricName().name().equals("request-latency-max")) continue;
            Assert.assertTrue((String)"Metrics should be collected (max latency shouldn't be 0)", (metric.value() != 0.0 ? 1 : 0) != 0);
        }
    }

    private CloseableHttpResponse makeGetRequest(String url, String basicAuth) throws Exception {
        log.debug("Making GET " + url);
        HttpGet httpget = new HttpGet(url);
        if (basicAuth != null) {
            httpget.setHeader("Authorization", "Basic " + basicAuth);
        }
        CloseableHttpResponse response = null;
        response = this.httpclient.execute((HttpUriRequest)httpget);
        return response;
    }

    private HttpResponse makeGetRequest(String url) throws Exception {
        return this.makeGetRequest(url, null);
    }

    @Path(value="/")
    @Produces(value={"text/plain"})
    public static class SaslTestResource {
        @GET
        @Path(value="/principal")
        @PerformanceMetric(value="principal")
        public String principal(@Context SecurityContext context) {
            return context.getUserPrincipal().getName();
        }

        @GET
        @Path(value="/role/{role}")
        @PerformanceMetric(value="role")
        public boolean hello(@PathParam(value="role") String role, @Context SecurityContext context) {
            return context.isUserInRole(role);
        }
    }

    private static class SaslTestApplication
    extends Application<TestRestConfig> {
        public SaslTestApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register((Object)new SaslTestResource());
        }

        public Map<String, String> getMetricsTags() {
            return Collections.singletonMap("instance-id", "1");
        }
    }
}

