/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.RestNotFoundException;
import io.confluent.rest.exceptions.RestServerErrorException;
import java.util.HashMap;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExceptionHandlingTest {
    TestRestConfig config;
    ExceptionApplication app;

    @Before
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("debug", "false");
        this.config = new TestRestConfig(props);
        this.app = new ExceptionApplication(this.config);
        this.app.start();
    }

    @After
    public void tearDown() throws Exception {
        this.app.stop();
        this.app.join();
    }

    private void testGetException(String path, int expectedStatus, int expectedErrorCode, String expectedMessage) {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target("http://localhost:" + this.config.getInt("port")).path(path).request().get();
        Assert.assertEquals((long)expectedStatus, (long)response.getStatus());
        ErrorMessage msg = (ErrorMessage)response.readEntity(ErrorMessage.class);
        Assert.assertEquals((long)expectedErrorCode, (long)msg.getErrorCode());
        Assert.assertEquals((Object)expectedMessage, (Object)msg.getMessage());
    }

    private void testPostException(String path, Entity entity, int expectedStatus, int expectedErrorCode, String expectedMessage) {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target("http://localhost:" + this.config.getInt("port")).path(path).request().post(entity);
        Assert.assertEquals((long)expectedStatus, (long)response.getStatus());
        ErrorMessage msg = (ErrorMessage)response.readEntity(ErrorMessage.class);
        Assert.assertEquals((long)expectedErrorCode, (long)msg.getErrorCode());
        Assert.assertEquals((Object)expectedMessage, (Object)msg.getMessage());
    }

    @Test
    public void testRestException() {
        this.testGetException("/restnotfound", 404, 4040, "Rest Not Found");
    }

    @Test
    public void testNonRestException() {
        this.testGetException("/notfound", 404, 404, "Generic Not Found");
    }

    @Test
    public void testUnexpectedException() {
        this.testGetException("/unexpected", 500, 50001, Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
    }

    @Test
    public void testUnrecognizedField() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("something", "something");
        m.put("something-else", "something-else");
        this.testPostException("/unrecognizedfield", Entity.json(m), 422, 422, "Unrecognized field: something-else");
    }

    @Produces(value={"application/json"})
    @Path(value="/")
    public static class ExceptionResource {
        @GET
        @Path(value="/restnotfound")
        public String restNotFound() {
            throw new RestNotFoundException("Rest Not Found", 4040);
        }

        @GET
        @Path(value="/notfound")
        public String notFound() {
            throw new NotFoundException("Generic Not Found");
        }

        @GET
        @Path(value="/unexpected")
        public String unexpected() {
            throw new RestServerErrorException("Internal Server Error", 50001);
        }

        @POST
        @Path(value="/unrecognizedfield")
        public String blah(FakeType ft) {
            return ft.something;
        }
    }

    private static class ExceptionApplication
    extends Application<TestRestConfig> {
        Configurable resourceConfig;

        ExceptionApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            this.resourceConfig = config;
            config.register(ExceptionResource.class);
        }
    }

    public static class FakeType {
        public String something;
    }
}

