/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import io.confluent.common.metrics.MeasurableStat;
import io.confluent.common.metrics.MetricName;
import io.confluent.common.metrics.Metrics;
import io.confluent.common.metrics.Sensor;
import io.confluent.common.metrics.stats.Avg;
import io.confluent.common.metrics.stats.Count;
import io.confluent.common.metrics.stats.Max;
import io.confluent.common.metrics.stats.Rate;
import io.confluent.common.metrics.stats.SampledStat;
import io.confluent.common.utils.Time;
import io.confluent.rest.annotations.PerformanceMetric;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

public class MetricsResourceMethodApplicationListener
implements ApplicationEventListener {
    private final Metrics metrics;
    private final String metricGrpPrefix;
    private Map<String, String> metricTags;
    Time time;
    private Map<Method, MethodMetrics> methodMetrics = new HashMap<Method, MethodMetrics>();

    public MetricsResourceMethodApplicationListener(Metrics metrics, String metricGrpPrefix, Map<String, String> metricTags, Time time) {
        this.metrics = metrics;
        this.metricGrpPrefix = metricGrpPrefix;
        this.metricTags = metricTags != null ? metricTags : Collections.emptyMap();
        this.time = time;
    }

    public void onEvent(ApplicationEvent event) {
        if (event.getType() == ApplicationEvent.Type.INITIALIZATION_FINISHED) {
            this.methodMetrics.put(null, new MethodMetrics(null, null, this.metrics, this.metricGrpPrefix, this.metricTags));
            for (Resource resource : event.getResourceModel().getResources()) {
                for (ResourceMethod method : resource.getAllMethods()) {
                    this.register(method);
                }
                for (Resource childResource : resource.getChildResources()) {
                    for (ResourceMethod method : childResource.getAllMethods()) {
                        this.register(method);
                    }
                }
            }
        }
    }

    private void register(ResourceMethod method) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        if (definitionMethod.isAnnotationPresent(PerformanceMetric.class)) {
            PerformanceMetric annotation = definitionMethod.getAnnotation(PerformanceMetric.class);
            this.methodMetrics.put(definitionMethod, new MethodMetrics(method, annotation, this.metrics, this.metricGrpPrefix, this.metricTags));
        }
    }

    public RequestEventListener onRequest(RequestEvent event) {
        return new MetricsRequestEventListener(this.methodMetrics, this.time);
    }

    private static class MetricsRequestEventListener
    implements RequestEventListener {
        private final Time time;
        private final Map<Method, MethodMetrics> metrics;
        private long started;
        private CountingInputStream wrappedRequestStream;
        private CountingOutputStream wrappedResponseStream;

        public MetricsRequestEventListener(Map<Method, MethodMetrics> metrics, Time time) {
            this.metrics = metrics;
            this.time = time;
        }

        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.MATCHING_START) {
                this.started = this.time.milliseconds();
                ContainerRequest request = event.getContainerRequest();
                this.wrappedRequestStream = new CountingInputStream(request.getEntityStream());
                request.setEntityStream((InputStream)this.wrappedRequestStream);
            } else if (event.getType() == RequestEvent.Type.RESP_FILTERS_START) {
                ContainerResponse response = event.getContainerResponse();
                this.wrappedResponseStream = new CountingOutputStream(response.getEntityStream());
                response.setEntityStream((OutputStream)this.wrappedResponseStream);
            } else if (event.getType() == RequestEvent.Type.ON_EXCEPTION) {
                this.metrics.get(null).exception();
                MethodMetrics metrics = this.getMethodMetrics(event);
                if (metrics != null) {
                    metrics.exception();
                }
            } else if (event.getType() == RequestEvent.Type.FINISHED) {
                long elapsed = this.time.milliseconds() - this.started;
                long requestSize = this.wrappedRequestStream.size();
                long responseSize = this.wrappedResponseStream.size();
                this.metrics.get(null).finished(requestSize, responseSize, elapsed);
                MethodMetrics metrics = this.getMethodMetrics(event);
                if (metrics != null) {
                    metrics.finished(requestSize, responseSize, elapsed);
                }
            }
        }

        private MethodMetrics getMethodMetrics(RequestEvent event) {
            ResourceMethod method = event.getUriInfo().getMatchedResourceMethod();
            if (method == null) {
                return null;
            }
            return this.metrics.get(method.getInvocable().getDefinitionMethod());
        }

        private static class CountingOutputStream
        extends FilterOutputStream {
            private long count = 0L;

            public CountingOutputStream(OutputStream os) {
                super(os);
            }

            public long size() {
                return this.count;
            }

            @Override
            public void write(int b) throws IOException {
                ++this.count;
                this.out.write(b);
            }

            @Override
            public void write(byte[] bytes) throws IOException {
                this.count += (long)bytes.length;
                this.out.write(bytes);
            }

            @Override
            public void write(byte[] bytes, int off, int len) throws IOException {
                this.count += (long)len;
                this.out.write(bytes, off, len);
            }
        }

        private static class CountingInputStream
        extends FilterInputStream {
            private long count = 0L;
            private long mark = 0L;

            public CountingInputStream(InputStream is) {
                super(is);
            }

            public long size() {
                return this.count;
            }

            @Override
            public int read() throws IOException {
                int b = super.read();
                ++this.count;
                return b;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                int nread = super.read(bytes, off, len);
                if (nread > 0) {
                    this.count += (long)nread;
                }
                return nread;
            }

            @Override
            public long skip(long l) throws IOException {
                long skipped = super.skip(l);
                this.count += skipped;
                return skipped;
            }

            @Override
            public synchronized void mark(int i) {
                super.mark(i);
                this.mark = this.count;
            }

            @Override
            public synchronized void reset() throws IOException {
                super.reset();
                this.count = this.mark;
            }
        }
    }

    private static class MethodMetrics {
        private Sensor requestSizeSensor;
        private Sensor responseSizeSensor;
        private Sensor requestLatencySensor;
        private Sensor errorSensor;

        public MethodMetrics(ResourceMethod method, PerformanceMetric annotation, Metrics metrics, String metricGrpPrefix, Map<String, String> metricTags) {
            String metricGrpName = metricGrpPrefix + "-metrics";
            this.requestSizeSensor = metrics.sensor(MethodMetrics.getName(method, annotation, "request-size"));
            MetricName metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-rate"), metricGrpName, "The average number of HTTP requests per second.", metricTags);
            this.requestSizeSensor.add(metricName, (MeasurableStat)new Rate((SampledStat)new Count()));
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-byte-rate"), metricGrpName, "Bytes/second of incoming requests", metricTags);
            this.requestSizeSensor.add(metricName, (MeasurableStat)new Avg());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-size-avg"), metricGrpName, "The average request size in bytes", metricTags);
            this.requestSizeSensor.add(metricName, (MeasurableStat)new Avg());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-size-max"), metricGrpName, "The maximum request size in bytes", metricTags);
            this.requestSizeSensor.add(metricName, (MeasurableStat)new Max());
            this.responseSizeSensor = metrics.sensor(MethodMetrics.getName(method, annotation, "response-size"));
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "response-rate"), metricGrpName, "The average number of HTTP responses per second.", metricTags);
            this.responseSizeSensor.add(metricName, (MeasurableStat)new Rate((SampledStat)new Count()));
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "response-byte-rate"), metricGrpName, "Bytes/second of outgoing responses", metricTags);
            this.responseSizeSensor.add(metricName, (MeasurableStat)new Avg());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "response-size-avg"), metricGrpName, "The average response size in bytes", metricTags);
            this.responseSizeSensor.add(metricName, (MeasurableStat)new Avg());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "response-size-max"), metricGrpName, "The maximum response size in bytes", metricTags);
            this.responseSizeSensor.add(metricName, (MeasurableStat)new Max());
            this.requestLatencySensor = metrics.sensor(MethodMetrics.getName(method, annotation, "request-latency"));
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-latency-avg"), metricGrpName, "The average request latency in ms", metricTags);
            this.requestLatencySensor.add(metricName, (MeasurableStat)new Avg());
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-latency-max"), metricGrpName, "The maximum request latency in ms", metricTags);
            this.requestLatencySensor.add(metricName, (MeasurableStat)new Max());
            this.errorSensor = metrics.sensor(MethodMetrics.getName(method, annotation, "errors"));
            metricName = new MetricName(MethodMetrics.getName(method, annotation, "request-error-rate"), metricGrpName, "The average number of requests per second that resulted in HTTP error responses", metricTags);
            this.errorSensor.add(metricName, (MeasurableStat)new Rate());
        }

        public void finished(long requestSize, long responseSize, long latencyMs) {
            this.requestSizeSensor.record((double)requestSize);
            this.responseSizeSensor.record((double)responseSize);
            this.requestLatencySensor.record((double)latencyMs);
        }

        public void exception() {
            this.errorSensor.record();
        }

        private static String getName(ResourceMethod method, PerformanceMetric annotation, String metric) {
            StringBuilder builder = new StringBuilder();
            boolean prefixed = false;
            if (annotation != null && !annotation.value().equals("__DEFAULT_NAME__")) {
                builder.append(annotation.value());
                builder.append('.');
                prefixed = true;
            }
            if (!prefixed && method != null) {
                String className = method.getInvocable().getDefinitionMethod().getDeclaringClass().getSimpleName();
                String methodName = method.getInvocable().getDefinitionMethod().getName();
                builder.append(className);
                builder.append('.');
                builder.append(methodName);
                builder.append('.');
            }
            builder.append(metric);
            return builder.toString();
        }
    }
}

