/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import io.confluent.common.config.ConfigException;
import io.confluent.common.metrics.JmxReporter;
import io.confluent.common.metrics.MetricConfig;
import io.confluent.common.metrics.Metrics;
import io.confluent.common.metrics.MetricsReporter;
import io.confluent.rest.MetricsListener;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import io.confluent.rest.exceptions.ConstraintViolationExceptionMapper;
import io.confluent.rest.exceptions.GenericExceptionMapper;
import io.confluent.rest.exceptions.WebApplicationExceptionMapper;
import io.confluent.rest.logging.Slf4jRequestLog;
import io.confluent.rest.metrics.MetricsResourceMethodApplicationListener;
import io.confluent.rest.validation.JacksonMessageBodyProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.validation.ValidationFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Application<T extends RestConfig> {
    protected T config;
    protected Server server = null;
    protected CountDownLatch shutdownLatch = new CountDownLatch(1);
    protected Metrics metrics;
    private static final Logger log = LoggerFactory.getLogger(Application.class);

    public Application(T config) {
        this.config = config;
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS);
        List reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        reporters.add(new JmxReporter(config.getString("metrics.jmx.prefix")));
        this.metrics = new Metrics(metricConfig, reporters, ((RestConfig)((Object)config)).getTime());
    }

    public abstract void setupResources(Configurable<?> var1, T var2);

    public Map<String, String> getMetricsTags() {
        return new LinkedHashMap<String, String>();
    }

    public Server createServer() throws RestConfigException {
        ResourceConfig resourceConfig = new ResourceConfig();
        Map<String, String> metricTags = this.getMetricsTags();
        this.configureBaseApplication((Configurable<?>)resourceConfig, metricTags);
        this.setupResources((Configurable<?>)resourceConfig, this.getConfiguration());
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        ServletHolder servletHolder = new ServletHolder((Servlet)servletContainer);
        this.server = new Server(){

            protected void doStop() throws Exception {
                super.doStop();
                Application.this.metrics.close();
                Application.this.onShutdown();
                Application.this.shutdownLatch.countDown();
            }
        };
        MetricsListener metricsListener = new MetricsListener(this.metrics, "jetty", metricTags);
        List<URI> listeners = Application.parseListeners(this.config.getList("listeners"), this.config.getInt("port"), Arrays.asList("http", "https"), "http");
        for (URI listener : listeners) {
            NetworkTrafficServerConnector connector;
            log.info("Adding listener: " + listener.toString());
            if (listener.getScheme().equals("http")) {
                connector = new NetworkTrafficServerConnector(this.server);
            } else {
                List excludedCipherSuites;
                List cipherSuites;
                List disabledProtocols;
                SslContextFactory sslContextFactory = new SslContextFactory();
                if (!this.config.getString("ssl.keystore.location").isEmpty()) {
                    sslContextFactory.setKeyStorePath(this.config.getString("ssl.keystore.location"));
                    sslContextFactory.setKeyStorePassword(this.config.getString("ssl.keystore.password"));
                    sslContextFactory.setKeyManagerPassword(this.config.getString("ssl.key.password"));
                    sslContextFactory.setKeyStoreType(this.config.getString("ssl.keystore.type"));
                    if (!this.config.getString("ssl.keymanager.algorithm").isEmpty()) {
                        sslContextFactory.setSslKeyManagerFactoryAlgorithm(this.config.getString("ssl.keymanager.algorithm"));
                    }
                }
                sslContextFactory.setNeedClientAuth(this.config.getBoolean("ssl.client.auth"));
                List enabledProtocols = this.config.getList("ssl.enabled.protocols");
                if (!enabledProtocols.isEmpty()) {
                    sslContextFactory.setIncludeProtocols((String[])enabledProtocols.toArray());
                }
                if (!(disabledProtocols = this.config.getList("ssl.disabled.protocols")).isEmpty()) {
                    sslContextFactory.setExcludeProtocols(disabledProtocols.toArray(new String[0]));
                }
                if (!(cipherSuites = this.config.getList("ssl.cipher.suites")).isEmpty()) {
                    sslContextFactory.setIncludeCipherSuites((String[])cipherSuites.toArray());
                }
                if (!(excludedCipherSuites = this.config.getList("ssl.cipher.suites.exclude")).isEmpty()) {
                    sslContextFactory.setExcludeCipherSuites(cipherSuites.toArray(new String[0]));
                }
                if (!this.config.getString("ssl.endpoint.identification.algorithm").isEmpty()) {
                    sslContextFactory.setEndpointIdentificationAlgorithm(this.config.getString("ssl.endpoint.identification.algorithm"));
                }
                if (!this.config.getString("ssl.truststore.location").isEmpty()) {
                    sslContextFactory.setTrustStorePath(this.config.getString("ssl.truststore.location"));
                    sslContextFactory.setTrustStorePassword(this.config.getString("ssl.truststore.password"));
                    sslContextFactory.setTrustStoreType(this.config.getString("ssl.truststore.type"));
                    if (!this.config.getString("ssl.trustmanager.algorithm").isEmpty()) {
                        sslContextFactory.setTrustManagerFactoryAlgorithm(this.config.getString("ssl.trustmanager.algorithm"));
                    }
                }
                sslContextFactory.setProtocol(this.config.getString("ssl.protocol"));
                if (!this.config.getString("ssl.provider").isEmpty()) {
                    sslContextFactory.setProtocol(this.config.getString("ssl.provider"));
                }
                connector = new NetworkTrafficServerConnector(this.server, sslContextFactory);
            }
            connector.addNetworkTrafficListener((NetworkTrafficListener)metricsListener);
            connector.setPort(listener.getPort());
            connector.setHost(listener.getHost());
            this.server.addConnector((Connector)connector);
        }
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(servletHolder, "/*");
        String allowedOrigins = this.getConfiguration().getString("access.control.allow.origin");
        if (allowedOrigins != null && !allowedOrigins.trim().isEmpty()) {
            FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
            filterHolder.setName("cross-origin");
            filterHolder.setInitParameter("allowedOrigins", allowedOrigins);
            String allowedMethods = this.getConfiguration().getString("access.control.allow.methods");
            if (allowedMethods != null && !allowedOrigins.trim().isEmpty()) {
                filterHolder.setInitParameter("allowedMethods", allowedMethods);
            }
            context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        Slf4jRequestLog requestLog = new Slf4jRequestLog();
        requestLog.setLoggerName(this.config.getString("request.logger.name"));
        requestLog.setLogLatency(true);
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{context, new DefaultHandler(), requestLogHandler});
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        this.server.setHandler((Handler)statsHandler);
        int gracefulShutdownMs = this.getConfiguration().getInt("shutdown.graceful.ms");
        if (gracefulShutdownMs > 0) {
            this.server.setStopTimeout((long)gracefulShutdownMs);
        }
        this.server.setStopAtShutdown(true);
        return this.server;
    }

    public static List<URI> parseListeners(List<String> listenersConfig, int deprecatedPort, List<String> supportedSchemes, String defaultScheme) {
        if (listenersConfig.isEmpty() || listenersConfig.get(0).isEmpty()) {
            log.warn("DEPRECATION warning: `listeners` configuration is not configured. Falling back to the deprecated `port` configuration.");
            listenersConfig = new ArrayList<String>(1);
            listenersConfig.add(defaultScheme + "://0.0.0.0:" + deprecatedPort);
        }
        ArrayList<URI> listeners = new ArrayList<URI>(listenersConfig.size());
        for (String listenerStr : listenersConfig) {
            URI uri;
            try {
                uri = new URI(listenerStr);
            }
            catch (URISyntaxException use) {
                throw new ConfigException("Could not parse a listener URI from the `listener` configuration option.");
            }
            String scheme = uri.getScheme();
            if (uri.getPort() == -1) {
                throw new ConfigException("Found a listener without a port. All listeners must have a port. The listener without a port is: " + listenerStr);
            }
            if (scheme != null && supportedSchemes.contains(scheme)) {
                listeners.add(uri);
                continue;
            }
            log.warn("Found a listener with an unsupported scheme (supported: " + supportedSchemes + "). Ignoring " + "listener '" + listenerStr + "'");
        }
        if (listeners.isEmpty()) {
            throw new ConfigException("No listeners are configured. Must have at least one listener.");
        }
        return listeners;
    }

    public void configureBaseApplication(Configurable<?> config) {
        this.configureBaseApplication(config, null);
    }

    public void configureBaseApplication(Configurable<?> config, Map<String, String> metricTags) {
        T restConfig = this.getConfiguration();
        ObjectMapper jsonMapper = this.getJsonMapper();
        JacksonMessageBodyProvider jsonProvider = new JacksonMessageBodyProvider(jsonMapper);
        config.register((Object)jsonProvider);
        config.register(JsonParseExceptionMapper.class);
        config.register(ValidationFeature.class);
        config.register(ConstraintViolationExceptionMapper.class);
        config.register((Object)new WebApplicationExceptionMapper((RestConfig)((Object)restConfig)));
        config.register((Object)new GenericExceptionMapper((RestConfig)((Object)restConfig)));
        config.register((Object)new MetricsResourceMethodApplicationListener(this.metrics, "jersey", metricTags, ((RestConfig)((Object)restConfig)).getTime()));
        config.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true);
    }

    public T getConfiguration() {
        return this.config;
    }

    protected ObjectMapper getJsonMapper() {
        return new ObjectMapper();
    }

    public void start() throws Exception {
        if (this.server == null) {
            this.createServer();
        }
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.server.join();
        this.shutdownLatch.await();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public void onShutdown() {
    }
}

