/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.common.config.ConfigException;
import io.confluent.rest.Application;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ApplicationTest {
    @Test
    public void testParseListenersDeprecated() {
        ArrayList listenersConfig = new ArrayList();
        List listeners = Application.parseListeners(listenersConfig, (int)8080, Arrays.asList("http", "https"), (String)"http");
        Assert.assertEquals((String)"Should have only one listener.", (long)1L, (long)listeners.size());
        this.assertExpectedUri((URI)listeners.get(0), "http", "0.0.0.0", 8080);
    }

    @Test
    public void testParseListenersHttpAndHttps() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost:123");
        listenersConfig.add("https://localhost:124");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
        Assert.assertEquals((String)"Should have two listeners.", (long)2L, (long)listeners.size());
        this.assertExpectedUri((URI)listeners.get(0), "http", "localhost", 123);
        this.assertExpectedUri((URI)listeners.get(1), "https", "localhost", 124);
    }

    @Test(expected=ConfigException.class)
    public void testParseListenersUnparseableUri() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("!");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
    }

    @Test
    public void testParseListenersUnsupportedScheme() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost:8080");
        listenersConfig.add("foo://localhost:8081");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
        Assert.assertEquals((String)"Should have one listener.", (long)1L, (long)listeners.size());
        this.assertExpectedUri((URI)listeners.get(0), "http", "localhost", 8080);
    }

    @Test(expected=ConfigException.class)
    public void testParseListenersNoSupportedListeners() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("foo://localhost:8080");
        listenersConfig.add("bar://localhost:8081");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
    }

    @Test(expected=ConfigException.class)
    public void testParseListenersNoPort() {
        ArrayList<String> listenersConfig = new ArrayList<String>();
        listenersConfig.add("http://localhost");
        List listeners = Application.parseListeners(listenersConfig, (int)-1, Arrays.asList("http", "https"), (String)"http");
    }

    private void assertExpectedUri(URI uri, String scheme, String host, int port) {
        Assert.assertEquals((String)("Scheme should be " + scheme), (Object)scheme, (Object)uri.getScheme());
        Assert.assertEquals((String)("Host should be " + host), (Object)host, (Object)uri.getHost());
        Assert.assertEquals((String)("Port should be " + port), (long)port, (long)uri.getPort());
    }
}

