/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.Generics;
import io.confluent.rest.MaprHomeSupport;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configurable;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.test.JerseyTest;
import org.glassfish.jersey.test.jetty.JettyTestContainerFactory;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class EmbeddedServerTestHarness<C extends RestConfig, T extends Application<C>> {
    private List<Object> resources = new Vector<Object>();
    private List<Class<?>> resourceClasses = new Vector();
    protected C config;
    protected T app;
    private JerseyTest test;

    public EmbeddedServerTestHarness() throws RestConfigException {
        this.config = this.createConfiguration();
    }

    public EmbeddedServerTestHarness(C config) {
        this.config = config;
    }

    private C createConfiguration() throws RestConfigException {
        Class<RestConfig> configClass = Generics.getTypeParameter(this.getClass(), RestConfig.class);
        try {
            return (C)configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RestConfigException("Couldn't find default constructor for " + configClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RestConfigException("Error invoking default constructor " + configClass.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RestConfigException("Error invoking default constructor for " + configClass.getName(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RestConfigException("Error invoking default constructor for " + configClass.getName(), (Throwable)e);
        }
    }

    protected T createApplication() throws RestConfigException {
        Class<Application> appClass = Generics.getTypeParameter(this.getClass(), Application.class);
        try {
            return (T)appClass.getConstructor(this.config.getClass()).newInstance(this.config);
        }
        catch (NoSuchMethodException e) {
            throw new RestConfigException("Couldn't find default constructor for " + appClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RestConfigException("Error invoking default constructor " + appClass.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RestConfigException("Error invoking default constructor for " + appClass.getName(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RestConfigException("Error invoking default constructor for " + appClass.getName(), (Throwable)e);
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        MaprHomeSupport.resetToDefaults();
        try {
            this.app = this.createApplication();
        }
        catch (RestConfigException ce) {
            throw new RuntimeException("Unexpected configuration error when configuring EmbeddedServerTestHarnesss.", ce);
        }
        this.getJerseyTest().setUp();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.test.tearDown();
        this.test = null;
    }

    protected void addResource(Object resource) {
        this.resources.add(resource);
    }

    protected void addResource(Class<?> resource) {
        this.resourceClasses.add(resource);
    }

    protected T getApp() {
        return this.app;
    }

    protected JerseyTest getJerseyTest() {
        if (this.test == null) {
            this.test = new JettyJerseyTest();
        }
        return this.test;
    }

    protected Invocation.Builder request(String target, String mediatype) {
        Invocation.Builder builder = this.getJerseyTest().target(target).request();
        if (mediatype != null) {
            builder.accept(new String[]{mediatype});
        }
        return builder;
    }

    static {
        MaprHomeSupport.activate();
    }

    private class JettyJerseyTest
    extends JerseyTest {
        public JettyJerseyTest() {
            super((TestContainerFactory)new JettyTestContainerFactory());
        }

        protected javax.ws.rs.core.Application configure() {
            ResourceConfig config = new ResourceConfig();
            EmbeddedServerTestHarness.this.app.configureBaseApplication((Configurable)config, null);
            for (Object resource : EmbeddedServerTestHarness.this.resources) {
                config.register(resource);
            }
            for (Object resource : EmbeddedServerTestHarness.this.resourceClasses) {
                config.register(resource);
            }
            return config;
        }

        protected void configureClient(ClientConfig config) {
            EmbeddedServerTestHarness.this.app.configureBaseApplication((Configurable)config, null);
        }
    }
}

