/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.mapr.web.security.WebSecurityConfig;
import io.confluent.common.utils.TestUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;

public class MaprHomeSupport {
    public static final File MAPR_HOME_FOLDER = TestUtils.tempDirectory();
    public static final String MAPR_HOME = MAPR_HOME_FOLDER.getPath();

    public static void activate() {
        if (!MaprHomeSupport.isActive()) {
            System.setProperty("mapr.home.dir", MAPR_HOME);
            MaprHomeSupport.changeEnvironmentVariable();
            MaprHomeSupport.assertWebSecurityUsesNewValue();
        }
        MaprHomeSupport.resetToDefaults();
    }

    public static boolean isActive() {
        return Objects.equals(System.getenv("MAPR_HOME"), MAPR_HOME);
    }

    private static void assertWebSecurityUsesNewValue() {
        Assert.assertEquals((String)"To correctly stub MAPR_HOME call MaprHomeSupport#stubMaprHomeForApplication before environment variable is used", (Object)MAPR_HOME, (Object)WebSecurityConfig.CONFIG.getMaprHome());
    }

    public static void resetToDefaults() {
        Assert.assertTrue((String)"MaprHomeSupport isn't active", (boolean)MaprHomeSupport.isActive());
        try {
            FileUtils.deleteQuietly((File)MAPR_HOME_FOLDER);
            MAPR_HOME_FOLDER.mkdirs();
            new File(MAPR_HOME_FOLDER, "conf").mkdirs();
            new File(WebSecurityConfig.CONFIG.getMaprClusterCfgLocation()).createNewFile();
            MaprHomeSupport.createSslXmlConfiguration("conf/ssl-server.xml", "server");
            MaprHomeSupport.createSslXmlConfiguration("conf/ssl-client.xml", "client");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createSslXmlConfiguration(String path, String role) throws IOException {
        Configuration xml = new Configuration();
        xml.set("ssl." + role + ".truststore.location", role + ".jks");
        xml.set("ssl." + role + ".truststore.type", "jks");
        xml.set("ssl." + role + ".keystore.location", role + ".jks");
        xml.set("ssl." + role + ".keystore.type", "jks");
        xml.set("ssl." + role + ".keystore.keypassword", "mapr");
        xml.set("ssl." + role + ".keystore.password", "mapr");
        xml.set("ssl." + role + ".truststore.password", "mapr");
        try (FileOutputStream stream = new FileOutputStream(new File(MAPR_HOME_FOLDER, path));){
            xml.writeXml((OutputStream)stream);
        }
    }

    private static void changeEnvironmentVariable() {
        try {
            Map<String, String> env = System.getenv();
            Field field = env.getClass().getDeclaredField("m");
            field.setAccessible(true);
            ((Map)field.get(env)).put("MAPR_HOME", MAPR_HOME);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Cannot mutate environment", e);
        }
    }
}

