/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.examples.helloworld;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.rest.examples.helloworld.HelloWorldRestConfig;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/hello")
@Produces(value={"application/vnd.hello.v1+json"})
public class HelloWorldResource {
    HelloWorldRestConfig config;

    public HelloWorldResource(HelloWorldRestConfig config) {
        this.config = config;
    }

    @GET
    @PerformanceMetric(value="hello-with-name")
    public HelloResponse hello(@QueryParam(value="name") String name) {
        return new HelloResponse(String.format(this.config.getString("greeting"), name == null ? "World" : name));
    }

    public static class HelloResponse {
        @NotEmpty
        private String message;

        public HelloResponse() {
        }

        public HelloResponse(String message) {
            this.message = message;
        }

        @JsonProperty
        public String getMessage() {
            return this.message;
        }
    }
}

