/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.examples.helloworld;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import io.confluent.rest.examples.helloworld.HelloWorldResource;
import io.confluent.rest.examples.helloworld.HelloWorldRestConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloWorldApplication
extends Application<HelloWorldRestConfig> {
    private static final Logger log = LoggerFactory.getLogger(HelloWorldApplication.class);

    public HelloWorldApplication(HelloWorldRestConfig config) {
        super((RestConfig)config);
    }

    public void setupResources(Configurable<?> config, HelloWorldRestConfig appConfig) {
        config.register((Object)new HelloWorldResource(appConfig));
        config.property("jersey.config.servlet.filter.staticContentRegex", (Object)"/(static/.*|.*\\.html|)");
    }

    public Map<String, String> getMetricsTags() {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("instance-id", "1");
        return tags;
    }

    protected ResourceCollection getStaticResources() {
        return new ResourceCollection(new Resource[]{Resource.newClassPathResource((String)"static")});
    }

    public static void main(String[] args) {
        try {
            TreeMap<String, String> settings = new TreeMap<String, String>();
            if (args.length > 0) {
                settings.put("greeting", args[0]);
            }
            HelloWorldRestConfig config = new HelloWorldRestConfig(settings);
            HelloWorldApplication app = new HelloWorldApplication(config);
            app.start();
            log.info("Server started, listening for requests...");
            app.join();
        }
        catch (RestConfigException e) {
            log.error("Server configuration failed: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            log.error("Server died unexpectedly: " + e.toString());
        }
    }
}

