/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.version.metrics;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.version.metrics.KsqlVersionChecker;
import io.confluent.support.metrics.submitters.ResponseHandler;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlVersionCheckerResponseHandler
implements ResponseHandler {
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(KsqlVersionChecker.class);
    private final Logger log;

    KsqlVersionCheckerResponseHandler() {
        this(DEFAULT_LOGGER);
    }

    @VisibleForTesting
    KsqlVersionCheckerResponseHandler(Logger log) {
        this.log = log;
    }

    public void handle(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        try {
            String content;
            if (statusCode == 200 && response.getEntity().getContent() != null && (content = EntityUtils.toString((HttpEntity)response.getEntity())).length() > 0) {
                this.log.warn(content.toString());
            }
        }
        catch (IOException e) {
            this.log.error("Error while parsing the Version check response ", (Throwable)e);
        }
    }
}

