/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.version.metrics;

import io.confluent.ksql.version.metrics.KsqlVersionChecker;
import io.confluent.ksql.version.metrics.VersionCheckerAgent;
import io.confluent.ksql.version.metrics.collector.KsqlModuleType;
import io.confluent.support.metrics.BaseSupportConfig;
import io.confluent.support.metrics.PhoneHomeConfig;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlVersionCheckerAgent
implements VersionCheckerAgent {
    private Thread versionCheckerThread;
    private KsqlVersionChecker ksqlVersionChecker;
    private boolean enableSettlingTime;
    private static final Logger log = LoggerFactory.getLogger(KsqlVersionCheckerAgent.class);

    public KsqlVersionCheckerAgent() {
        this(true);
    }

    public KsqlVersionCheckerAgent(boolean enableSettlingTime) {
        this.enableSettlingTime = enableSettlingTime;
    }

    @Override
    public void start(KsqlModuleType moduleType, Properties ksqlProperties) {
        PhoneHomeConfig ksqlVersionCheckerConfig = new PhoneHomeConfig(ksqlProperties, "ksql");
        if (ksqlVersionCheckerConfig.isProactiveSupportEnabled()) {
            try {
                Runtime serverRuntime = Runtime.getRuntime();
                this.ksqlVersionChecker = new KsqlVersionChecker((BaseSupportConfig)ksqlVersionCheckerConfig, serverRuntime, moduleType, this.enableSettlingTime);
                this.ksqlVersionChecker.init();
                this.versionCheckerThread = KsqlVersionCheckerAgent.newThread("KsqlVersionCheckerAgent", (Runnable)((Object)this.ksqlVersionChecker));
                long reportIntervalMs = ksqlVersionCheckerConfig.getReportIntervalMs();
                long reportIntervalHours = reportIntervalMs / 3600000L;
                this.versionCheckerThread.start();
                log.warn(KsqlVersionCheckerAgent.legalDisclaimerProactiveSupportEnabled(reportIntervalHours));
            }
            catch (Exception e) {
                log.error("Failed to start KsqlVersionCheckerAgent: {}", (Object)e.getMessage());
            }
        } else {
            log.warn(KsqlVersionCheckerAgent.legalDisclaimerProactiveSupportDisabled());
        }
    }

    private static Thread newThread(String name, Runnable runnable) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((t, e) -> log.error("Uncaught exception in thread '{}':", (Object)t.getName(), (Object)e));
        return thread;
    }

    private static String legalDisclaimerProactiveSupportEnabled(long reportIntervalHours) {
        return "Please note that the version check feature of KSQL is enabled.  With this enabled, this instance is configured to collect and report anonymously the version information to Confluent, Inc. (\"Confluent\") or its parent, subsidiaries, affiliates or service providers every " + reportIntervalHours + "hours.  This Metadata may be transferred to any country in which Confluent maintains " + "facilities.  For a more in depth discussion of how Confluent processes " + "such information, please read our Privacy Policy located at " + "http://www.confluent.io/privacy. " + "By proceeding with `" + "confluent.support.metrics.enable" + "=true`, " + "you agree to all such collection, transfer and use of Version information " + "by Confluent. You can turn the version check  feature off by setting `" + "confluent.support.metrics.enable" + "=false` in the " + "KSQL configuration and restarting the KSQL.  See the Confluent Platform " + "documentation for further information.";
    }

    private static String legalDisclaimerProactiveSupportDisabled() {
        return "The version check feature of KSQL  is disabled.";
    }
}

