/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.version.metrics;

import io.confluent.ksql.version.metrics.KsqlVersionCheckerResponseHandler;
import io.confluent.ksql.version.metrics.collector.BasicCollector;
import io.confluent.ksql.version.metrics.collector.KsqlModuleType;
import io.confluent.support.metrics.BaseMetricsReporter;
import io.confluent.support.metrics.BaseSupportConfig;
import io.confluent.support.metrics.common.Collector;
import io.confluent.support.metrics.common.kafka.ZkClientProvider;
import io.confluent.support.metrics.common.time.TimeUtils;
import io.confluent.support.metrics.submitters.ResponseHandler;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class KsqlVersionChecker
extends BaseMetricsReporter {
    private final Collector metricsCollector;
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);

    public KsqlVersionChecker(BaseSupportConfig ksqlVersionCheckerConfig, Runtime serverRuntime, KsqlModuleType moduleType, boolean enableSettlingTime) {
        super(ksqlVersionCheckerConfig, null, (ResponseHandler)new KsqlVersionCheckerResponseHandler(), enableSettlingTime);
        Objects.requireNonNull(serverRuntime, "serverRuntime is required");
        serverRuntime.addShutdownHook(new Thread(() -> this.shuttingDown.set(true)));
        this.metricsCollector = new BasicCollector(moduleType, new TimeUtils());
    }

    protected ZkClientProvider zkClientProvider() {
        return null;
    }

    protected Collector metricsCollector() {
        return this.metricsCollector;
    }

    protected boolean isReadyForMetricsCollection() {
        return true;
    }

    protected boolean isShuttingDown() {
        return this.shuttingDown.get();
    }
}

