/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.parser.tree.KsqlWindowExpression;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class WindowExpression
extends Node {
    private final String windowName;
    private final KsqlWindowExpression ksqlWindowExpression;

    public WindowExpression(String windowName, KsqlWindowExpression ksqlWindowExpression) {
        this(Optional.empty(), windowName, ksqlWindowExpression);
    }

    protected WindowExpression(Optional<NodeLocation> location, String windowName, KsqlWindowExpression ksqlWindowExpression) {
        super(location);
        this.windowName = windowName;
        this.ksqlWindowExpression = ksqlWindowExpression;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public KsqlWindowExpression getKsqlWindowExpression() {
        return this.ksqlWindowExpression;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowExpression o = (WindowExpression)obj;
        return Objects.equals(this.ksqlWindowExpression, o.ksqlWindowExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.windowName, this.ksqlWindowExpression);
    }

    @Override
    public String toString() {
        return " WINDOW " + this.windowName + " " + this.ksqlWindowExpression.toString();
    }

    public static TimeUnit getWindowUnit(String windowUnitString) {
        switch (windowUnitString) {
            case "DAY": 
            case "DAYS": {
                return TimeUnit.DAYS;
            }
            case "HOUR": 
            case "HOURS": {
                return TimeUnit.HOURS;
            }
            case "MINUTE": 
            case "MINUTES": {
                return TimeUnit.MINUTES;
            }
            case "SECOND": 
            case "SECONDS": {
                return TimeUnit.SECONDS;
            }
            case "MILLISECOND": 
            case "MILLISECONDS": {
                return TimeUnit.MILLISECONDS;
            }
        }
        return null;
    }
}

