/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.function.UdafAggregator;
import io.confluent.ksql.parser.tree.KsqlWindowExpression;
import io.confluent.ksql.parser.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windows;

public class TumblingWindowExpression
extends KsqlWindowExpression {
    private final long size;
    private final TimeUnit sizeUnit;

    public TumblingWindowExpression(long size, TimeUnit sizeUnit) {
        this(Optional.empty(), size, sizeUnit);
    }

    private TumblingWindowExpression(Optional<NodeLocation> location, long size, TimeUnit sizeUnit) {
        super(location);
        this.size = size;
        this.sizeUnit = sizeUnit;
    }

    @Override
    public String toString() {
        return " TUMBLING ( SIZE " + this.size + " " + (Object)((Object)this.sizeUnit) + " ) ";
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.sizeUnit});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TumblingWindowExpression tumblingWindowExpression = (TumblingWindowExpression)o;
        return tumblingWindowExpression.size == this.size && tumblingWindowExpression.sizeUnit == this.sizeUnit;
    }

    @Override
    public KTable applyAggregate(KGroupedStream groupedStream, Initializer initializer, UdafAggregator aggregator, Materialized<String, GenericRow, ?> materialized) {
        return groupedStream.windowedBy((Windows)TimeWindows.of((long)this.sizeUnit.toMillis(this.size))).aggregate(initializer, (Aggregator)aggregator, materialized);
    }
}

