/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class SubscriptExpression
extends Expression {
    private final Expression base;
    private final Expression index;

    public SubscriptExpression(Expression base, Expression index) {
        this(Optional.empty(), base, index);
    }

    public SubscriptExpression(NodeLocation location, Expression base, Expression index) {
        this(Optional.of(location), base, index);
    }

    private SubscriptExpression(Optional<NodeLocation> location, Expression base, Expression index) {
        super(location);
        this.base = Objects.requireNonNull(base, "base is null");
        this.index = Objects.requireNonNull(index, "index is null");
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSubscriptExpression(this, context);
    }

    public Expression getBase() {
        return this.base;
    }

    public Expression getIndex() {
        return this.index;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptExpression that = (SubscriptExpression)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.index, that.index);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.index);
    }
}

