/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.confluent.ksql.parser.ExpressionFormatter;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.GroupingElement;
import io.confluent.ksql.parser.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SimpleGroupBy
extends GroupingElement {
    private final List<Expression> columns;

    public SimpleGroupBy(NodeLocation location, List<Expression> simpleGroupByExpressions) {
        this(Optional.of(location), simpleGroupByExpressions);
    }

    private SimpleGroupBy(Optional<NodeLocation> location, List<Expression> simpleGroupByExpressions) {
        super(location);
        this.columns = Objects.requireNonNull(simpleGroupByExpressions);
    }

    public List<Expression> getColumnExpressions() {
        return this.columns;
    }

    @Override
    public List<Set<Expression>> enumerateGroupingSets() {
        return ImmutableList.of((Object)ImmutableSet.copyOf(this.columns));
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSimpleGroupBy(this, context);
    }

    @Override
    public String format() {
        ImmutableSet columns = ImmutableSet.copyOf(this.columns);
        if (columns.size() == 1) {
            return ExpressionFormatter.formatExpression((Expression)Iterables.getOnlyElement((Iterable)columns));
        }
        return ExpressionFormatter.formatGroupingSet((Set<Expression>)columns);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleGroupBy that = (SimpleGroupBy)o;
        return Objects.equals(this.columns, that.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columns);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columns).toString();
    }
}

