/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.DDLStatement;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RegisterTopic
extends Statement
implements DDLStatement {
    private final QualifiedName name;
    private final boolean notExists;
    private final Map<String, Expression> properties;

    public RegisterTopic(QualifiedName name, boolean notExists, Map<String, Expression> properties) {
        this(Optional.empty(), name, notExists, properties);
    }

    public RegisterTopic(NodeLocation location, QualifiedName name, boolean notExists, Map<String, Expression> properties) {
        this(Optional.of(location), name, notExists, properties);
    }

    private RegisterTopic(Optional<NodeLocation> location, QualifiedName name, boolean notExists, Map<String, Expression> properties) {
        super(location);
        this.name = Objects.requireNonNull(name, "topic is null");
        this.notExists = notExists;
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
    }

    public QualifiedName getName() {
        return this.name;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public Map<String, Expression> getProperties() {
        return this.properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTopic(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.notExists, this.properties);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegisterTopic o = (RegisterTopic)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.properties, o.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("notExists", this.notExists).add("properties", this.properties).toString();
    }
}

