/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QueryBody;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

public class Query
extends Statement {
    private final QueryBody queryBody;
    private final Optional<String> limit;

    public Query(QueryBody queryBody, Optional<String> limit) {
        this(Optional.empty(), queryBody, limit);
    }

    public Query(NodeLocation location, QueryBody queryBody, Optional<String> limit) {
        this(Optional.of(location), queryBody, limit);
    }

    private Query(Optional<NodeLocation> location, QueryBody queryBody, Optional<String> limit) {
        super(location);
        Objects.requireNonNull(queryBody, "queryBody is null");
        Objects.requireNonNull(limit, "limit is null");
        this.queryBody = queryBody;
        this.limit = limit;
    }

    public QueryBody getQueryBody() {
        return this.queryBody;
    }

    public Optional<String> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryBody", (Object)this.queryBody).add("limit", this.limit.orElse(null)).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Query o = (Query)obj;
        return Objects.equals(this.queryBody, o.queryBody) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.queryBody, this.limit);
    }
}

