/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.LongLiteral;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

public class PrintTopic
extends Statement {
    private final QualifiedName topic;
    private final boolean fromBeginning;
    private final LongLiteral intervalValue;

    public PrintTopic(QualifiedName topic, boolean fromBeginning, LongLiteral intervalValue) {
        this(Optional.empty(), topic, fromBeginning, intervalValue);
    }

    public PrintTopic(NodeLocation location, QualifiedName topic, boolean fromBeginning, LongLiteral intervalValue) {
        this(Optional.of(location), topic, fromBeginning, intervalValue);
    }

    private PrintTopic(Optional<NodeLocation> location, QualifiedName topic, boolean fromBeginning, LongLiteral intervalValue) {
        super(location);
        this.topic = Objects.requireNonNull(topic, "table is null");
        this.fromBeginning = fromBeginning;
        this.intervalValue = intervalValue;
    }

    public QualifiedName getTopic() {
        return this.topic;
    }

    public boolean getFromBeginning() {
        return this.fromBeginning;
    }

    public LongLiteral getIntervalValue() {
        return this.intervalValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrintTopic)) {
            return false;
        }
        PrintTopic that = (PrintTopic)o;
        return this.getFromBeginning() == that.getFromBeginning() && Objects.equals(this.getTopic(), that.getTopic()) && Objects.equals(this.getIntervalValue(), that.getIntervalValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getTopic(), this.getFromBeginning(), this.getIntervalValue());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).toString();
    }
}

