/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.Preconditions;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import java.util.Optional;

public class FieldReference
extends Expression {
    private final int fieldIndex;

    public FieldReference(int fieldIndex) {
        super(Optional.empty());
        Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (Object)"fieldIndex must be >= 0");
        this.fieldIndex = fieldIndex;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFieldReference(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldReference that = (FieldReference)o;
        return this.fieldIndex == that.fieldIndex;
    }

    @Override
    public int hashCode() {
        return this.fieldIndex;
    }
}

