/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.Query;
import java.util.Objects;
import java.util.Optional;

public class ExistsPredicate
extends Expression {
    private final Query subquery;

    public ExistsPredicate(Query subquery) {
        this(Optional.empty(), subquery);
    }

    public ExistsPredicate(NodeLocation location, Query subquery) {
        this(Optional.of(location), subquery);
    }

    private ExistsPredicate(Optional<NodeLocation> location, Query subquery) {
        super(location);
        Objects.requireNonNull(subquery, "subquery is null");
        this.subquery = subquery;
    }

    public Query getSubquery() {
        return this.subquery;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExists(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExistsPredicate that = (ExistsPredicate)o;
        return Objects.equals(this.subquery, that.subquery);
    }

    @Override
    public int hashCode() {
        return this.subquery.hashCode();
    }
}

