/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.Preconditions;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.QualifiedNameReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DereferenceExpression
extends Expression {
    private final Expression base;
    private final String fieldName;

    public DereferenceExpression(Expression base, String fieldName) {
        this(Optional.empty(), base, fieldName);
    }

    public DereferenceExpression(NodeLocation location, Expression base, String fieldName) {
        this(Optional.of(location), base, fieldName);
    }

    private DereferenceExpression(Optional<NodeLocation> location, Expression base, String fieldName) {
        super(location);
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"base is null");
        Preconditions.checkArgument((fieldName != null ? 1 : 0) != 0, (Object)"fieldName is null");
        this.base = base;
        this.fieldName = fieldName;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDereferenceExpression(this, context);
    }

    public Expression getBase() {
        return this.base;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public static QualifiedName getQualifiedName(DereferenceExpression expression) {
        List<String> parts = DereferenceExpression.tryParseParts(expression.base, expression.fieldName);
        return parts == null ? null : QualifiedName.of(parts);
    }

    private static List<String> tryParseParts(Expression base, String fieldName) {
        QualifiedName baseQualifiedName;
        if (base instanceof QualifiedNameReference) {
            ArrayList<String> newList = new ArrayList<String>(((QualifiedNameReference)base).getName().getParts());
            newList.add(fieldName);
            return newList;
        }
        if (base instanceof DereferenceExpression && (baseQualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)base)) != null) {
            ArrayList<String> newList = new ArrayList<String>(baseQualifiedName.getParts());
            newList.add(fieldName);
            return newList;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DereferenceExpression that = (DereferenceExpression)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.fieldName, that.fieldName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.fieldName);
    }
}

