/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

public class CreateView
extends Statement {
    private final QualifiedName name;
    private final Query query;
    private final boolean replace;

    public CreateView(QualifiedName name, Query query, boolean replace) {
        this(Optional.empty(), name, query, replace);
    }

    public CreateView(NodeLocation location, QualifiedName name, Query query, boolean replace) {
        this(Optional.of(location), name, query, replace);
    }

    private CreateView(Optional<NodeLocation> location, QualifiedName name, Query query, boolean replace) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.replace = replace;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isReplace() {
        return this.replace;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateView(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.replace);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateView o = (CreateView)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.replace, o.replace);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("replace", this.replace).toString();
    }
}

