/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.parser.tree.AbstractStreamCreateStatement;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.DDLStatement;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.TableElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CreateTable
extends AbstractStreamCreateStatement
implements DDLStatement {
    private final QualifiedName name;
    private final List<TableElement> elements;
    private final boolean notExists;
    private final Map<String, Expression> properties;

    public CreateTable(QualifiedName name, List<TableElement> elements, boolean notExists, Map<String, Expression> properties) {
        this(Optional.empty(), name, elements, notExists, properties);
    }

    public CreateTable(NodeLocation location, QualifiedName name, List<TableElement> elements, boolean notExists, Map<String, Expression> properties) {
        this(Optional.of(location), name, elements, notExists, properties);
    }

    private CreateTable(Optional<NodeLocation> location, QualifiedName name, List<TableElement> elements, boolean notExists, Map<String, Expression> properties) {
        super(location);
        this.name = Objects.requireNonNull(name, "table is null");
        this.elements = ImmutableList.copyOf((Collection)Objects.requireNonNull(elements, "elements is null"));
        this.notExists = notExists;
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
    }

    @Override
    public QualifiedName getName() {
        return this.name;
    }

    @Override
    public List<TableElement> getElements() {
        return this.elements;
    }

    @Override
    public AbstractStreamCreateStatement copyWith(List<TableElement> elements, Map<String, Expression> properties) {
        return new CreateTable(this.name, elements, this.notExists, properties);
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    @Override
    public Map<String, Expression> getProperties() {
        return this.properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTable(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.elements, this.notExists, this.properties);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateTable o = (CreateTable)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.elements, o.elements) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.properties, o.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("elements", this.elements).add("notExists", this.notExists).add("properties", this.properties).toString();
    }
}

