/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CreateStreamAsSelect
extends Statement
implements CreateAsSelect {
    private final QualifiedName name;
    private final Query query;
    private final boolean notExists;
    private final Map<String, Expression> properties;
    private final Optional<Expression> partitionByColumn;

    public CreateStreamAsSelect(NodeLocation location, QualifiedName name, Query query, boolean notExists, Map<String, Expression> properties, Optional<Expression> partitionByColumn) {
        this(Optional.of(location), name, query, notExists, properties, partitionByColumn);
    }

    private CreateStreamAsSelect(Optional<NodeLocation> location, QualifiedName name, Query query, boolean notExists, Map<String, Expression> properties, Optional<Expression> partitionByColumn) {
        super(location);
        this.name = Objects.requireNonNull(name, "stream is null");
        this.query = query;
        this.notExists = notExists;
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.partitionByColumn = partitionByColumn;
    }

    @Override
    public QualifiedName getName() {
        return this.name;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    @Override
    public Map<String, Expression> getProperties() {
        return this.properties;
    }

    @Override
    public Optional<Expression> getPartitionByColumn() {
        return this.partitionByColumn;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateStreamAsSelect(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.notExists, this.properties);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateStreamAsSelect o = (CreateStreamAsSelect)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.properties, o.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("notExists", this.notExists).add("properties", this.properties).toString();
    }
}

