/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.Relation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AliasedRelation
extends Relation {
    private final Relation relation;
    private final String alias;
    private final List<String> columnNames;

    public AliasedRelation(Relation relation, String alias, List<String> columnNames) {
        this(Optional.empty(), relation, alias, columnNames);
    }

    public AliasedRelation(NodeLocation location, Relation relation, String alias, List<String> columnNames) {
        this(Optional.of(location), relation, alias, columnNames);
    }

    private AliasedRelation(Optional<NodeLocation> location, Relation relation, String alias, List<String> columnNames) {
        super(location);
        Objects.requireNonNull(relation, "relation is null");
        Objects.requireNonNull(alias, " is null");
        this.relation = relation;
        this.alias = alias.toUpperCase();
        this.columnNames = columnNames;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public String getAlias() {
        return this.alias;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAliasedRelation(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relation", (Object)this.relation).add("alias", (Object)this.alias).add("columnNames", this.columnNames).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasedRelation that = (AliasedRelation)o;
        return Objects.equals(this.relation, that.relation) && Objects.equals(this.alias, that.alias) && Objects.equals(this.columnNames, that.columnNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.relation, this.alias, this.columnNames);
    }
}

