/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.confluent.ksql.metastore.KsqlStream;
import io.confluent.ksql.metastore.KsqlTopic;
import io.confluent.ksql.metastore.StructuredDataSource;
import io.confluent.ksql.parser.ParsingException;
import io.confluent.ksql.parser.SqlBaseBaseVisitor;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.parser.tree.ArithmeticUnaryExpression;
import io.confluent.ksql.parser.tree.BetweenPredicate;
import io.confluent.ksql.parser.tree.BinaryLiteral;
import io.confluent.ksql.parser.tree.BooleanLiteral;
import io.confluent.ksql.parser.tree.Cast;
import io.confluent.ksql.parser.tree.ComparisonExpression;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.DecimalLiteral;
import io.confluent.ksql.parser.tree.DereferenceExpression;
import io.confluent.ksql.parser.tree.DoubleLiteral;
import io.confluent.ksql.parser.tree.DropStream;
import io.confluent.ksql.parser.tree.DropTable;
import io.confluent.ksql.parser.tree.DropTopic;
import io.confluent.ksql.parser.tree.ExistsPredicate;
import io.confluent.ksql.parser.tree.Explain;
import io.confluent.ksql.parser.tree.ExplainFormat;
import io.confluent.ksql.parser.tree.ExplainOption;
import io.confluent.ksql.parser.tree.ExplainType;
import io.confluent.ksql.parser.tree.ExportCatalog;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.Extract;
import io.confluent.ksql.parser.tree.FunctionCall;
import io.confluent.ksql.parser.tree.GenericLiteral;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.GroupingElement;
import io.confluent.ksql.parser.tree.HoppingWindowExpression;
import io.confluent.ksql.parser.tree.InListExpression;
import io.confluent.ksql.parser.tree.InPredicate;
import io.confluent.ksql.parser.tree.IntervalLiteral;
import io.confluent.ksql.parser.tree.IsNotNullPredicate;
import io.confluent.ksql.parser.tree.IsNullPredicate;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinCriteria;
import io.confluent.ksql.parser.tree.JoinOn;
import io.confluent.ksql.parser.tree.JoinUsing;
import io.confluent.ksql.parser.tree.LambdaExpression;
import io.confluent.ksql.parser.tree.LikePredicate;
import io.confluent.ksql.parser.tree.ListProperties;
import io.confluent.ksql.parser.tree.ListQueries;
import io.confluent.ksql.parser.tree.ListRegisteredTopics;
import io.confluent.ksql.parser.tree.ListStreams;
import io.confluent.ksql.parser.tree.ListTables;
import io.confluent.ksql.parser.tree.ListTopics;
import io.confluent.ksql.parser.tree.LogicalBinaryExpression;
import io.confluent.ksql.parser.tree.LongLiteral;
import io.confluent.ksql.parser.tree.NaturalJoin;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NodeLocation;
import io.confluent.ksql.parser.tree.NotExpression;
import io.confluent.ksql.parser.tree.NullIfExpression;
import io.confluent.ksql.parser.tree.NullLiteral;
import io.confluent.ksql.parser.tree.PrintTopic;
import io.confluent.ksql.parser.tree.QualifiedName;
import io.confluent.ksql.parser.tree.QualifiedNameReference;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.QueryBody;
import io.confluent.ksql.parser.tree.QuerySpecification;
import io.confluent.ksql.parser.tree.RegisterTopic;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.Row;
import io.confluent.ksql.parser.tree.RunScript;
import io.confluent.ksql.parser.tree.SearchedCaseExpression;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SessionWindowExpression;
import io.confluent.ksql.parser.tree.SetProperty;
import io.confluent.ksql.parser.tree.ShowColumns;
import io.confluent.ksql.parser.tree.SimpleCaseExpression;
import io.confluent.ksql.parser.tree.SimpleGroupBy;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.Statements;
import io.confluent.ksql.parser.tree.StringLiteral;
import io.confluent.ksql.parser.tree.SubqueryExpression;
import io.confluent.ksql.parser.tree.SubscriptExpression;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.parser.tree.TableSubquery;
import io.confluent.ksql.parser.tree.TerminateQuery;
import io.confluent.ksql.parser.tree.TimeLiteral;
import io.confluent.ksql.parser.tree.TimestampLiteral;
import io.confluent.ksql.parser.tree.TumblingWindowExpression;
import io.confluent.ksql.parser.tree.UnsetProperty;
import io.confluent.ksql.parser.tree.Values;
import io.confluent.ksql.parser.tree.WhenClause;
import io.confluent.ksql.parser.tree.Window;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.parser.tree.WithQuery;
import io.confluent.ksql.util.DataSourceExtractor;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class AstBuilder
extends SqlBaseBaseVisitor<Node> {
    private int selectItemIndex = 0;
    private static final String DEFAULT_WINDOW_NAME = "StreamWindow";
    private DataSourceExtractor dataSourceExtractor;

    public AstBuilder(DataSourceExtractor dataSourceExtractor) {
        this.dataSourceExtractor = dataSourceExtractor;
    }

    @Override
    public Node visitStatements(SqlBaseParser.StatementsContext context) {
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        for (SqlBaseParser.SingleStatementContext singleStatementContext : context.singleStatement()) {
            Statement statement = (Statement)this.visitSingleStatement(singleStatementContext);
            statementList.add(statement);
        }
        return new Statements(statementList);
    }

    @Override
    public Node visitSingleStatement(SqlBaseParser.SingleStatementContext context) {
        return (Statement)this.visit((ParseTree)context.statement());
    }

    @Override
    public Node visitQuerystatement(SqlBaseParser.QuerystatementContext ctx) {
        return (Statement)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Node visitSingleExpression(SqlBaseParser.SingleExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expression());
    }

    private Map<String, Expression> processTableProperties(SqlBaseParser.TablePropertiesContext tablePropertiesContext) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        if (tablePropertiesContext != null) {
            for (SqlBaseParser.TablePropertyContext tablePropertyContext : tablePropertiesContext.tableProperty()) {
                properties.put((Object)AstBuilder.getIdentifierText(tablePropertyContext.identifier()), (Object)((Expression)this.visit((ParseTree)tablePropertyContext.expression())));
            }
        }
        return properties.build();
    }

    @Override
    public Node visitCreateTable(SqlBaseParser.CreateTableContext context) {
        return new CreateTable(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), this.visit(context.tableElement(), TableElement.class), context.EXISTS() != null, this.processTableProperties(context.tableProperties()));
    }

    @Override
    public Node visitRegisterTopic(SqlBaseParser.RegisterTopicContext context) {
        return new RegisterTopic(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), context.EXISTS() != null, this.processTableProperties(context.tableProperties()));
    }

    @Override
    public Node visitCreateStream(SqlBaseParser.CreateStreamContext context) {
        return new CreateStream(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), this.visit(context.tableElement(), TableElement.class), context.EXISTS() != null, this.processTableProperties(context.tableProperties()));
    }

    @Override
    public Node visitCreateStreamAs(SqlBaseParser.CreateStreamAsContext context) {
        Optional<Expression> partitionByColumn = Optional.empty();
        if (context.identifier() != null) {
            partitionByColumn = Optional.of(new QualifiedNameReference(QualifiedName.of(AstBuilder.getIdentifierText(context.identifier()))));
        }
        return new CreateStreamAsSelect(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), (Query)this.visitQuery(context.query()), context.EXISTS() != null, this.processTableProperties(context.tableProperties()), partitionByColumn);
    }

    @Override
    public Node visitCreateTableAs(SqlBaseParser.CreateTableAsContext context) {
        return new CreateTableAsSelect(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), (Query)this.visitQuery(context.query()), context.EXISTS() != null, this.processTableProperties(context.tableProperties()));
    }

    @Override
    public Node visitDropTopic(SqlBaseParser.DropTopicContext context) {
        return new DropTopic(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), context.EXISTS() != null);
    }

    @Override
    public Node visitDropTable(SqlBaseParser.DropTableContext context) {
        return new DropTable(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), context.EXISTS() != null);
    }

    @Override
    public Node visitDropStream(SqlBaseParser.DropStreamContext context) {
        return new DropStream(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), context.EXISTS() != null);
    }

    @Override
    public Node visitQuery(SqlBaseParser.QueryContext context) {
        Query body = (Query)this.visit((ParseTree)context.queryNoWith());
        return new Query(AstBuilder.getLocation(context), body.getQueryBody(), body.getLimit());
    }

    @Override
    public Node visitNamedQuery(SqlBaseParser.NamedQueryContext context) {
        return new WithQuery(AstBuilder.getLocation(context), context.name.getText(), (Query)this.visit((ParseTree)context.query()), Optional.ofNullable(AstBuilder.getColumnAliases(context.columnAliases())));
    }

    @Override
    public Node visitQueryNoWith(SqlBaseParser.QueryNoWithContext context) {
        QueryBody term = (QueryBody)this.visit((ParseTree)context.queryTerm());
        if (term instanceof QuerySpecification) {
            QuerySpecification query = (QuerySpecification)term;
            return new Query(AstBuilder.getLocation(context), (QueryBody)new QuerySpecification(AstBuilder.getLocation(context), query.getSelect(), query.getInto(), query.getFrom(), query.getWindowExpression(), query.getWhere(), query.getGroupBy(), query.getHaving(), AstBuilder.getTextIfPresent(context.limit)), Optional.empty());
        }
        return new Query(AstBuilder.getLocation(context), term, AstBuilder.getTextIfPresent(context.limit));
    }

    @Override
    public Node visitQuerySpecification(SqlBaseParser.QuerySpecificationContext context) {
        Table into;
        if (context.into != null) {
            into = (Table)this.visit((ParseTree)context.into);
        } else {
            String intoName = "KSQL_Stream_" + System.currentTimeMillis();
            into = new Table(QualifiedName.of(intoName), true);
        }
        Relation from = (Relation)this.visit((ParseTree)context.from);
        Select select = new Select(AstBuilder.getLocation(context.SELECT()), false, this.visit(context.selectItem(), SelectItem.class));
        select = new Select(AstBuilder.getLocation(context.SELECT()), select.isDistinct(), this.extractSelectItems(select, from));
        this.getResultDatasource(select, into);
        return new QuerySpecification(AstBuilder.getLocation(context), select, (Relation)into, from, this.visitIfPresent(context.windowExpression(), WindowExpression.class), this.visitIfPresent(context.where, Expression.class), this.visitIfPresent(context.groupBy(), GroupBy.class), this.visitIfPresent(context.having, Expression.class), Optional.empty());
    }

    private List<SelectItem> extractSelectItems(Select select, Relation from) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (SelectItem selectItem : select.getSelectItems()) {
            if (selectItem instanceof AllColumns) {
                selectItems.addAll(this.getSelectStartItems(selectItem, from));
                continue;
            }
            if (selectItem instanceof SingleColumn) {
                selectItems.add((SingleColumn)selectItem);
                continue;
            }
            throw new IllegalArgumentException("Unsupported SelectItem type: " + selectItem.getClass().getName());
        }
        return selectItems;
    }

    private List<SelectItem> getSelectStartItems(SelectItem selectItem, Relation from) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        AllColumns allColumns = (AllColumns)selectItem;
        if (from instanceof Join) {
            SingleColumn newSelectItem;
            QualifiedNameReference qualifiedNameReference;
            Join join = (Join)from;
            AliasedRelation left = (AliasedRelation)join.getLeft();
            StructuredDataSource leftDataSource = this.dataSourceExtractor.getMetaStore().getSource(left.getRelation().toString());
            if (leftDataSource == null) {
                throw new InvalidColumnReferenceException(left.getRelation().toString() + " does not exist.");
            }
            AliasedRelation right = (AliasedRelation)join.getRight();
            StructuredDataSource rightDataSource = this.dataSourceExtractor.getMetaStore().getSource(right.getRelation().toString());
            if (rightDataSource == null) {
                throw new InvalidColumnReferenceException(right.getRelation().toString() + " does not exist.");
            }
            for (Field field : leftDataSource.getSchema().fields()) {
                qualifiedNameReference = new QualifiedNameReference(allColumns.getLocation().get(), QualifiedName.of(left.getAlias() + "." + field.name()));
                newSelectItem = new SingleColumn((Expression)qualifiedNameReference, left.getAlias() + "_" + field.name());
                selectItems.add(newSelectItem);
            }
            for (Field field : rightDataSource.getSchema().fields()) {
                qualifiedNameReference = new QualifiedNameReference(allColumns.getLocation().get(), QualifiedName.of(right.getAlias() + "." + field.name()));
                newSelectItem = new SingleColumn((Expression)qualifiedNameReference, right.getAlias() + "_" + field.name());
                selectItems.add(newSelectItem);
            }
        } else {
            AliasedRelation fromRel = (AliasedRelation)from;
            StructuredDataSource fromDataSource = this.dataSourceExtractor.getMetaStore().getSource(((Table)fromRel.getRelation()).getName().getSuffix());
            if (fromDataSource == null) {
                throw new InvalidColumnReferenceException(((Table)fromRel.getRelation()).getName().getSuffix() + " does not exist.");
            }
            for (Field field : fromDataSource.getSchema().fields()) {
                QualifiedNameReference qualifiedNameReference = new QualifiedNameReference(allColumns.getLocation().get(), QualifiedName.of(fromDataSource.getName() + "." + field.name()));
                SingleColumn newSelectItem = new SingleColumn((Expression)qualifiedNameReference, field.name());
                selectItems.add(newSelectItem);
            }
        }
        return selectItems;
    }

    @Override
    public Node visitWindowExpression(SqlBaseParser.WindowExpressionContext ctx) {
        String windowName = DEFAULT_WINDOW_NAME;
        if (ctx.IDENTIFIER() != null) {
            windowName = ctx.IDENTIFIER().getText();
        }
        windowName = windowName.toUpperCase();
        if (ctx.tumblingWindowExpression() != null) {
            TumblingWindowExpression tumblingWindowExpression = (TumblingWindowExpression)this.visitTumblingWindowExpression(ctx.tumblingWindowExpression());
            return new WindowExpression(windowName, tumblingWindowExpression);
        }
        if (ctx.hoppingWindowExpression() != null) {
            HoppingWindowExpression hoppingWindowExpression = (HoppingWindowExpression)this.visitHoppingWindowExpression(ctx.hoppingWindowExpression());
            return new WindowExpression(windowName, hoppingWindowExpression);
        }
        if (ctx.sessionWindowExpression() != null) {
            SessionWindowExpression sessionWindowExpression = (SessionWindowExpression)this.visitSessionWindowExpression(ctx.sessionWindowExpression());
            return new WindowExpression(windowName, sessionWindowExpression);
        }
        throw new KsqlException("Window description is not correct.");
    }

    @Override
    public Node visitHoppingWindowExpression(SqlBaseParser.HoppingWindowExpressionContext ctx) {
        List<SqlBaseParser.NumberContext> numberList = ctx.number();
        List<SqlBaseParser.WindowUnitContext> windowUnits = ctx.windowUnit();
        String sizeStr = numberList.get(0).getText();
        String advanceByStr = numberList.get(1).getText();
        String sizeUnit = windowUnits.get(0).getText();
        String advanceByUnit = windowUnits.get(1).getText();
        return new HoppingWindowExpression(Long.parseLong(sizeStr), WindowExpression.getWindowUnit(sizeUnit.toUpperCase()), Long.parseLong(advanceByStr), WindowExpression.getWindowUnit(advanceByUnit.toUpperCase()));
    }

    @Override
    public Node visitTumblingWindowExpression(SqlBaseParser.TumblingWindowExpressionContext ctx) {
        String sizeStr = ctx.number().getText();
        String sizeUnit = ctx.windowUnit().getText();
        return new TumblingWindowExpression(Long.parseLong(sizeStr), WindowExpression.getWindowUnit(sizeUnit.toUpperCase()));
    }

    @Override
    public Node visitSessionWindowExpression(SqlBaseParser.SessionWindowExpressionContext ctx) {
        String sizeStr = ctx.number().getText();
        String sizeUnit = ctx.windowUnit().getText();
        return new SessionWindowExpression(Long.parseLong(sizeStr), WindowExpression.getWindowUnit(sizeUnit.toUpperCase()));
    }

    @Override
    public Node visitGroupBy(SqlBaseParser.GroupByContext context) {
        return new GroupBy(AstBuilder.getLocation(context), false, this.visit(context.groupingElement(), GroupingElement.class));
    }

    @Override
    public Node visitSingleGroupingSet(SqlBaseParser.SingleGroupingSetContext context) {
        return new SimpleGroupBy(AstBuilder.getLocation(context), this.visit(context.groupingExpressions().expression(), Expression.class));
    }

    @Override
    public Node visitSelectAll(SqlBaseParser.SelectAllContext context) {
        if (context.qualifiedName() != null) {
            return new AllColumns(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()));
        }
        return new AllColumns(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitSelectSingle(SqlBaseParser.SelectSingleContext context) {
        Expression selectItemExpression = (Expression)this.visit((ParseTree)context.expression());
        Optional<String> alias = Optional.ofNullable(context.identifier()).map(AstBuilder::getIdentifierText);
        if (!alias.isPresent()) {
            if (selectItemExpression instanceof QualifiedNameReference) {
                QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)selectItemExpression;
                alias = Optional.of(qualifiedNameReference.getName().getSuffix());
            } else if (selectItemExpression instanceof DereferenceExpression) {
                DereferenceExpression dereferenceExpression = (DereferenceExpression)selectItemExpression;
                alias = this.dataSourceExtractor.getJoinLeftSchema() != null && this.dataSourceExtractor.getCommonFieldNames().contains(dereferenceExpression.getFieldName()) ? Optional.of(dereferenceExpression.getBase().toString() + "_" + dereferenceExpression.getFieldName()) : Optional.of(dereferenceExpression.getFieldName());
            } else {
                alias = Optional.of("KSQL_COL_" + this.selectItemIndex);
            }
        } else {
            alias = Optional.of(alias.get());
        }
        ++this.selectItemIndex;
        return new SingleColumn(AstBuilder.getLocation(context), selectItemExpression, alias);
    }

    @Override
    public Node visitQualifiedName(SqlBaseParser.QualifiedNameContext context) {
        return (Node)this.visitChildren((RuleNode)context);
    }

    @Override
    public Node visitTable(SqlBaseParser.TableContext context) {
        return new Table(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitExportCatalog(SqlBaseParser.ExportCatalogContext context) {
        return new ExportCatalog(Optional.ofNullable(AstBuilder.getLocation(context)), context.STRING().getText());
    }

    @Override
    public Node visitRunScript(SqlBaseParser.RunScriptContext context) {
        return new RunScript(Optional.ofNullable(AstBuilder.getLocation(context)), context.STRING().getText());
    }

    @Override
    public Node visitListRegisteredTopics(SqlBaseParser.ListRegisteredTopicsContext context) {
        return new ListRegisteredTopics(Optional.ofNullable(AstBuilder.getLocation(context)));
    }

    @Override
    public Node visitListTopics(SqlBaseParser.ListTopicsContext context) {
        Optional<Object> streamName = Optional.ofNullable(context.STRING() != null ? QualifiedName.of(AstBuilder.unquote(context.STRING().getText(), "'")) : (context.qualifiedName() != null ? AstBuilder.getQualifiedName(context.qualifiedName()) : null));
        return new ListTopics(Optional.ofNullable(AstBuilder.getLocation(context)), streamName);
    }

    @Override
    public Node visitListStreams(SqlBaseParser.ListStreamsContext context) {
        return new ListStreams(Optional.ofNullable(AstBuilder.getLocation(context)));
    }

    @Override
    public Node visitListTables(SqlBaseParser.ListTablesContext context) {
        return new ListTables(Optional.ofNullable(AstBuilder.getLocation(context)));
    }

    @Override
    public Node visitListQueries(SqlBaseParser.ListQueriesContext context) {
        return new ListQueries(Optional.ofNullable(AstBuilder.getLocation(context)));
    }

    @Override
    public Node visitTerminateQuery(SqlBaseParser.TerminateQueryContext context) {
        return new TerminateQuery(AstBuilder.getLocation(context), context.qualifiedName().getText());
    }

    @Override
    public Node visitShowColumns(SqlBaseParser.ShowColumnsContext context) {
        return new ShowColumns(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), context.TOPIC() != null, context.EXTENDED() != null);
    }

    @Override
    public Node visitListProperties(SqlBaseParser.ListPropertiesContext context) {
        return new ListProperties(Optional.ofNullable(AstBuilder.getLocation(context)));
    }

    @Override
    public Node visitSetProperty(SqlBaseParser.SetPropertyContext context) {
        String propertyName = AstBuilder.unquote(context.STRING(0).getText(), "'");
        String propertyValue = AstBuilder.unquote(context.STRING(1).getText(), "'");
        return new SetProperty(Optional.ofNullable(AstBuilder.getLocation(context)), propertyName, propertyValue);
    }

    @Override
    public Node visitUnsetProperty(SqlBaseParser.UnsetPropertyContext context) {
        String propertyName = AstBuilder.unquote(context.STRING().getText(), "'");
        return new UnsetProperty(Optional.ofNullable(AstBuilder.getLocation(context)), propertyName);
    }

    @Override
    public Node visitPrintTopic(SqlBaseParser.PrintTopicContext context) {
        boolean fromBeginning = context.FROM() != null;
        QualifiedName topicName = null;
        topicName = context.STRING() != null ? QualifiedName.of(AstBuilder.unquote(context.STRING().getText(), "'")) : AstBuilder.getQualifiedName(context.qualifiedName());
        if (context.number() == null) {
            return new PrintTopic(AstBuilder.getLocation(context), topicName, fromBeginning, null);
        }
        if (context.number() instanceof SqlBaseParser.IntegerLiteralContext) {
            SqlBaseParser.IntegerLiteralContext integerLiteralContext = (SqlBaseParser.IntegerLiteralContext)context.number();
            return new PrintTopic(AstBuilder.getLocation(context), topicName, fromBeginning, (LongLiteral)this.visitIntegerLiteral(integerLiteralContext));
        }
        throw new KsqlException("Interval value should be integer in 'PRINT' command!");
    }

    @Override
    public Node visitNumericLiteral(SqlBaseParser.NumericLiteralContext ctx) {
        return (Node)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Node visitSubquery(SqlBaseParser.SubqueryContext context) {
        return new TableSubquery(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.queryNoWith()));
    }

    @Override
    public Node visitInlineTable(SqlBaseParser.InlineTableContext context) {
        return new Values(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitExplainFormat(SqlBaseParser.ExplainFormatContext context) {
        switch (context.value.getType()) {
            case 137: {
                return new ExplainFormat(AstBuilder.getLocation(context), ExplainFormat.Type.GRAPHVIZ);
            }
            case 136: {
                return new ExplainFormat(AstBuilder.getLocation(context), ExplainFormat.Type.TEXT);
            }
        }
        throw new IllegalArgumentException("Unsupported EXPLAIN format: " + context.value.getText());
    }

    @Override
    public Node visitExplainType(SqlBaseParser.ExplainTypeContext context) {
        switch (context.value.getType()) {
            case 138: {
                return new ExplainType(AstBuilder.getLocation(context), ExplainType.Type.LOGICAL);
            }
            case 139: {
                return new ExplainType(AstBuilder.getLocation(context), ExplainType.Type.DISTRIBUTED);
            }
        }
        throw new IllegalArgumentException("Unsupported EXPLAIN type: " + context.value.getText());
    }

    @Override
    public Node visitLogicalNot(SqlBaseParser.LogicalNotContext context) {
        return new NotExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.booleanExpression()));
    }

    @Override
    public Node visitLogicalBinary(SqlBaseParser.LogicalBinaryContext context) {
        return new LogicalBinaryExpression(AstBuilder.getLocation(context.operator), AstBuilder.getLogicalBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitJoinRelation(SqlBaseParser.JoinRelationContext context) {
        JoinCriteria criteria;
        Relation right;
        Relation left = (Relation)this.visit((ParseTree)context.left);
        if (context.CROSS() != null) {
            Relation right2 = (Relation)this.visit((ParseTree)context.right);
            return new Join(AstBuilder.getLocation(context), Join.Type.CROSS, left, right2, Optional.empty());
        }
        if (context.NATURAL() != null) {
            right = (Relation)this.visit((ParseTree)context.right);
            criteria = new NaturalJoin();
        } else {
            right = (Relation)this.visit((ParseTree)context.rightRelation);
            if (context.joinCriteria().ON() != null) {
                criteria = new JoinOn((Expression)this.visit((ParseTree)context.joinCriteria().booleanExpression()));
            } else if (context.joinCriteria().USING() != null) {
                List<String> columns = context.joinCriteria().identifier().stream().map(AstBuilder::getIdentifierText).collect(Collectors.toList());
                criteria = new JoinUsing(columns);
            } else {
                throw new IllegalArgumentException("Unsupported join criteria");
            }
        }
        Join.Type joinType = context.joinType().LEFT() != null ? Join.Type.LEFT : (context.joinType().RIGHT() != null ? Join.Type.RIGHT : (context.joinType().FULL() != null ? Join.Type.FULL : Join.Type.INNER));
        return new Join(AstBuilder.getLocation(context), joinType, left, right, Optional.of(criteria));
    }

    @Override
    public Node visitAliasedRelation(SqlBaseParser.AliasedRelationContext context) {
        String alias;
        Relation child = (Relation)this.visit((ParseTree)context.relationPrimary());
        if (context.children.size() == 1) {
            Table table = (Table)this.visit((ParseTree)context.relationPrimary());
            alias = table.getName().getSuffix();
        } else if (context.children.size() == 2) {
            alias = ((ParseTree)context.children.get(1)).getText();
        } else {
            throw new IllegalArgumentException("AliasedRelationContext must have either 1 or 2 children, but has:" + context.children.size());
        }
        return new AliasedRelation(AstBuilder.getLocation(context), child, alias, AstBuilder.getColumnAliases(context.columnAliases()));
    }

    @Override
    public Node visitTableName(SqlBaseParser.TableNameContext context) {
        Table table = new Table(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()));
        if (context.tableProperties() != null) {
            table.setProperties(this.processTableProperties(context.tableProperties()));
        }
        return table;
    }

    @Override
    public Node visitSubqueryRelation(SqlBaseParser.SubqueryRelationContext context) {
        return new TableSubquery(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitParenthesizedRelation(SqlBaseParser.ParenthesizedRelationContext context) {
        return (Node)this.visit((ParseTree)context.relation());
    }

    @Override
    public Node visitPredicated(SqlBaseParser.PredicatedContext context) {
        if (context.predicate() != null) {
            return (Node)this.visit((ParseTree)context.predicate());
        }
        return (Node)this.visit((ParseTree)context.valueExpression);
    }

    @Override
    public Node visitComparison(SqlBaseParser.ComparisonContext context) {
        return new ComparisonExpression(AstBuilder.getLocation(context.comparisonOperator()), AstBuilder.getComparisonOperator(((TerminalNode)context.comparisonOperator().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitDistinctFrom(SqlBaseParser.DistinctFromContext context) {
        Expression expression = new ComparisonExpression(AstBuilder.getLocation(context), ComparisonExpression.Type.IS_DISTINCT_FROM, (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
        if (context.NOT() != null) {
            expression = new NotExpression(AstBuilder.getLocation(context), expression);
        }
        return expression;
    }

    @Override
    public Node visitBetween(SqlBaseParser.BetweenContext context) {
        Expression expression = new BetweenPredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.lower), (Expression)this.visit((ParseTree)context.upper));
        if (context.NOT() != null) {
            expression = new NotExpression(AstBuilder.getLocation(context), expression);
        }
        return expression;
    }

    @Override
    public Node visitNullPredicate(SqlBaseParser.NullPredicateContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.value);
        if (context.NOT() == null) {
            return new IsNullPredicate(AstBuilder.getLocation(context), child);
        }
        return new IsNotNullPredicate(AstBuilder.getLocation(context), child);
    }

    @Override
    public Node visitLike(SqlBaseParser.LikeContext context) {
        Expression escape = null;
        if (context.escape != null) {
            escape = (Expression)this.visit((ParseTree)context.escape);
        }
        Expression result = new LikePredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.pattern), escape);
        if (context.NOT() != null) {
            result = new NotExpression(AstBuilder.getLocation(context), result);
        }
        return result;
    }

    @Override
    public Node visitInList(SqlBaseParser.InListContext context) {
        Expression result = new InPredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)new InListExpression(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class)));
        if (context.NOT() != null) {
            result = new NotExpression(AstBuilder.getLocation(context), result);
        }
        return result;
    }

    @Override
    public Node visitInSubquery(SqlBaseParser.InSubqueryContext context) {
        Expression result = new InPredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)new SubqueryExpression(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query())));
        if (context.NOT() != null) {
            result = new NotExpression(AstBuilder.getLocation(context), result);
        }
        return result;
    }

    @Override
    public Node visitExists(SqlBaseParser.ExistsContext context) {
        return new ExistsPredicate(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitArithmeticUnary(SqlBaseParser.ArithmeticUnaryContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.valueExpression());
        switch (context.operator.getType()) {
            case 221: {
                return ArithmeticUnaryExpression.negative(AstBuilder.getLocation(context), child);
            }
            case 220: {
                return ArithmeticUnaryExpression.positive(AstBuilder.getLocation(context), child);
            }
        }
        throw new UnsupportedOperationException("Unsupported sign: " + context.operator.getText());
    }

    @Override
    public Node visitArithmeticBinary(SqlBaseParser.ArithmeticBinaryContext context) {
        return new ArithmeticBinaryExpression(AstBuilder.getLocation(context.operator), AstBuilder.getArithmeticBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitConcatenation(SqlBaseParser.ConcatenationContext context) {
        return new FunctionCall(AstBuilder.getLocation(context.CONCAT()), QualifiedName.of("concat"), (List<Expression>)ImmutableList.of((Object)((Expression)this.visit((ParseTree)context.left)), (Object)((Expression)this.visit((ParseTree)context.right))));
    }

    @Override
    public Node visitTimeZoneInterval(SqlBaseParser.TimeZoneIntervalContext context) {
        return (Node)this.visit((ParseTree)context.interval());
    }

    @Override
    public Node visitTimeZoneString(SqlBaseParser.TimeZoneStringContext context) {
        return new StringLiteral(AstBuilder.getLocation(context), AstBuilder.unquote(context.STRING().getText(), "'"));
    }

    @Override
    public Node visitParenthesizedExpression(SqlBaseParser.ParenthesizedExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expression());
    }

    @Override
    public Node visitRowConstructor(SqlBaseParser.RowConstructorContext context) {
        return new Row(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitCast(SqlBaseParser.CastContext context) {
        boolean isTryCast = context.TRY_CAST() != null;
        return new Cast(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression()), AstBuilder.getType(context.type()), isTryCast);
    }

    @Override
    public Node visitExtract(SqlBaseParser.ExtractContext context) {
        Extract.Field field;
        String fieldString = AstBuilder.getIdentifierText(context.identifier());
        try {
            field = Extract.Field.valueOf(fieldString);
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(String.format("Invalid EXTRACT field: %s", fieldString), null, context.getStart().getLine(), context.getStart().getCharPositionInLine());
        }
        return new Extract(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.valueExpression()), field);
    }

    @Override
    public Node visitSubstring(SqlBaseParser.SubstringContext context) {
        return new FunctionCall(AstBuilder.getLocation(context), QualifiedName.of("SUBSTR"), this.visit(context.valueExpression(), Expression.class));
    }

    @Override
    public Node visitPosition(SqlBaseParser.PositionContext context) {
        List arguments = Lists.reverse(this.visit(context.valueExpression(), Expression.class));
        return new FunctionCall(AstBuilder.getLocation(context), QualifiedName.of("STRPOS"), (List<Expression>)arguments);
    }

    @Override
    public Node visitNormalize(SqlBaseParser.NormalizeContext context) {
        Expression str = (Expression)this.visit((ParseTree)context.valueExpression());
        String normalForm = Optional.ofNullable(context.normalForm()).map(RuleContext::getText).orElse("NFC");
        return new FunctionCall(AstBuilder.getLocation(context), QualifiedName.of("NORMALIZE"), (List<Expression>)ImmutableList.of((Object)str, (Object)new StringLiteral(AstBuilder.getLocation(context), normalForm)));
    }

    @Override
    public Node visitSubscript(SqlBaseParser.SubscriptContext context) {
        return new SubscriptExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.index));
    }

    @Override
    public Node visitSubqueryExpression(SqlBaseParser.SubqueryExpressionContext context) {
        return new SubqueryExpression(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitDereference(SqlBaseParser.DereferenceContext context) {
        String fieldName = AstBuilder.getIdentifierText(context.identifier());
        QualifiedName tableName = QualifiedName.of(context.primaryExpression().getText().toUpperCase());
        QualifiedNameReference baseExpression = new QualifiedNameReference(AstBuilder.getLocation(context.primaryExpression()), tableName);
        DereferenceExpression dereferenceExpression = new DereferenceExpression(AstBuilder.getLocation(context), (Expression)baseExpression, fieldName);
        return dereferenceExpression;
    }

    @Override
    public Node visitColumnReference(SqlBaseParser.ColumnReferenceContext context) {
        String columnName = AstBuilder.getIdentifierText(context.identifier());
        if (this.dataSourceExtractor.getJoinLeftSchema() != null) {
            if (this.dataSourceExtractor.getCommonFieldNames().contains(columnName)) {
                throw new KsqlException("Field " + columnName + " is ambiguous.");
            }
            if (this.dataSourceExtractor.getLeftFieldNames().contains(columnName)) {
                QualifiedNameReference baseExpression = new QualifiedNameReference(AstBuilder.getLocation(context), QualifiedName.of(this.dataSourceExtractor.getLeftAlias()));
                return new DereferenceExpression(AstBuilder.getLocation(context), (Expression)baseExpression, columnName);
            }
            if (this.dataSourceExtractor.getRightFieldNames().contains(columnName)) {
                QualifiedNameReference baseExpression = new QualifiedNameReference(AstBuilder.getLocation(context), QualifiedName.of(this.dataSourceExtractor.getRightAlias()));
                return new DereferenceExpression(AstBuilder.getLocation(context), (Expression)baseExpression, columnName);
            }
            throw new InvalidColumnReferenceException("Field " + columnName + " is ambiguous.");
        }
        QualifiedNameReference baseExpression = new QualifiedNameReference(AstBuilder.getLocation(context), QualifiedName.of(this.dataSourceExtractor.getFromAlias()));
        return new DereferenceExpression(AstBuilder.getLocation(context), (Expression)baseExpression, columnName);
    }

    @Override
    public Node visitSimpleCase(SqlBaseParser.SimpleCaseContext context) {
        return new SimpleCaseExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.valueExpression()), this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent(context.elseExpression, Expression.class));
    }

    @Override
    public Node visitSearchedCase(SqlBaseParser.SearchedCaseContext context) {
        return new SearchedCaseExpression(AstBuilder.getLocation(context), this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent(context.elseExpression, Expression.class));
    }

    @Override
    public Node visitWhenClause(SqlBaseParser.WhenClauseContext context) {
        return new WhenClause(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.condition), (Expression)this.visit((ParseTree)context.result));
    }

    @Override
    public Node visitFunctionCall(SqlBaseParser.FunctionCallContext context) {
        Optional<Window> window = this.visitIfPresent(context.over(), Window.class);
        QualifiedName name = AstBuilder.getQualifiedName(context.qualifiedName());
        boolean distinct = false;
        if (name.toString().equals("NULLIF")) {
            AstBuilder.check(context.expression().size() == 2, "Invalid number of arguments for 'nullif' function", context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'nullif' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'nullif' function", context);
            return new NullIfExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression(0)), (Expression)this.visit((ParseTree)context.expression(1)));
        }
        return new FunctionCall(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), window, distinct, this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitLambda(SqlBaseParser.LambdaContext context) {
        List<String> arguments = context.identifier().stream().map(AstBuilder::getIdentifierText).collect(Collectors.toList());
        Expression body = (Expression)this.visit((ParseTree)context.expression());
        return new LambdaExpression(arguments, body);
    }

    @Override
    public Node visitTableElement(SqlBaseParser.TableElementContext context) {
        return new TableElement(AstBuilder.getLocation(context), AstBuilder.getIdentifierText(context.identifier()), AstBuilder.getType(context.type()));
    }

    @Override
    public Node visitNullLiteral(SqlBaseParser.NullLiteralContext context) {
        return new NullLiteral(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitStringLiteral(SqlBaseParser.StringLiteralContext context) {
        return new StringLiteral(AstBuilder.getLocation(context), AstBuilder.unquote(context.STRING().getText(), "'"));
    }

    @Override
    public Node visitBinaryLiteral(SqlBaseParser.BinaryLiteralContext context) {
        String raw = context.BINARY_LITERAL().getText();
        return new BinaryLiteral(AstBuilder.getLocation(context), AstBuilder.unquote(raw.substring(1), "'"));
    }

    @Override
    public Node visitTypeConstructor(SqlBaseParser.TypeConstructorContext context) {
        String type = AstBuilder.getIdentifierText(context.identifier());
        String value = AstBuilder.unquote(context.STRING().getText(), "'");
        if (type.equals("TIME")) {
            return new TimeLiteral(AstBuilder.getLocation(context), value);
        }
        if (type.equals("TIMESTAMP")) {
            return new TimestampLiteral(AstBuilder.getLocation(context), value);
        }
        if (type.equals("DECIMAL")) {
            return new DecimalLiteral(AstBuilder.getLocation(context), value);
        }
        return new GenericLiteral(AstBuilder.getLocation(context), type, value);
    }

    @Override
    public Node visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext context) {
        return new LongLiteral(AstBuilder.getLocation(context), context.getText());
    }

    @Override
    public Node visitDecimalLiteral(SqlBaseParser.DecimalLiteralContext context) {
        return new DoubleLiteral(AstBuilder.getLocation(context), context.getText());
    }

    @Override
    public Node visitBooleanValue(SqlBaseParser.BooleanValueContext context) {
        return new BooleanLiteral(AstBuilder.getLocation(context), context.getText());
    }

    @Override
    public Node visitInterval(SqlBaseParser.IntervalContext context) {
        return new IntervalLiteral(AstBuilder.getLocation(context), AstBuilder.unquote(context.STRING().getText(), "'"), Optional.ofNullable(context.sign).map(AstBuilder::getIntervalSign).orElse(IntervalLiteral.Sign.POSITIVE), AstBuilder.getIntervalFieldType((Token)context.from.getChild(0).getPayload()), Optional.ofNullable(context.to).map(x -> x.getChild(0).getPayload()).map(Token.class::cast).map(AstBuilder::getIntervalFieldType));
    }

    @Override
    public Node visitExplain(SqlBaseParser.ExplainContext ctx) {
        SqlBaseParser.QualifiedNameContext qualifiedName = ctx.qualifiedName();
        String queryId = null;
        if (qualifiedName != null) {
            queryId = qualifiedName.getText();
        }
        Statement statement = null;
        if (ctx.statement() != null) {
            statement = (Statement)this.visit((ParseTree)ctx.statement());
        }
        return new Explain(queryId, statement, false, Arrays.asList(new ExplainOption[0]));
    }

    protected Node defaultResult() {
        return null;
    }

    protected Node aggregateResult(Node aggregate, Node nextResult) {
        if (nextResult == null) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if (aggregate == null) {
            return nextResult;
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    private <T> Optional<T> visitIfPresent(ParserRuleContext context, Class<T> clazz) {
        return Optional.ofNullable(context).map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast);
    }

    private <T> List<T> visit(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        return contexts.stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast).collect(Collectors.toList());
    }

    public static String getIdentifierText(SqlBaseParser.IdentifierContext context) {
        if (context instanceof SqlBaseParser.QuotedIdentifierAlternativeContext) {
            return AstBuilder.unquote(context.getText(), "\"");
        }
        if (context instanceof SqlBaseParser.BackQuotedIdentifierContext) {
            return AstBuilder.unquote(context.getText(), "`");
        }
        return context.getText().toUpperCase();
    }

    public static String unquote(String value, String quote) {
        return value.substring(1, value.length() - 1).replace(quote + quote, quote);
    }

    private static QualifiedName getQualifiedName(SqlBaseParser.QualifiedNameContext context) {
        List<String> parts = context.identifier().stream().map(AstBuilder::getIdentifierText).collect(Collectors.toList());
        return QualifiedName.of(parts);
    }

    private static Optional<String> getTextIfPresent(Token token) {
        return Optional.ofNullable(token).map(Token::getText);
    }

    private static List<String> getColumnAliases(SqlBaseParser.ColumnAliasesContext columnAliasesContext) {
        if (columnAliasesContext == null) {
            return null;
        }
        return columnAliasesContext.identifier().stream().map(AstBuilder::getIdentifierText).collect(Collectors.toList());
    }

    private static ArithmeticBinaryExpression.Type getArithmeticBinaryOperator(Token operator) {
        switch (operator.getType()) {
            case 220: {
                return ArithmeticBinaryExpression.Type.ADD;
            }
            case 221: {
                return ArithmeticBinaryExpression.Type.SUBTRACT;
            }
            case 222: {
                return ArithmeticBinaryExpression.Type.MULTIPLY;
            }
            case 223: {
                return ArithmeticBinaryExpression.Type.DIVIDE;
            }
            case 224: {
                return ArithmeticBinaryExpression.Type.MODULUS;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator: " + operator.getText());
    }

    private static ComparisonExpression.Type getComparisonOperator(Token symbol) {
        switch (symbol.getType()) {
            case 214: {
                return ComparisonExpression.Type.EQUAL;
            }
            case 215: {
                return ComparisonExpression.Type.NOT_EQUAL;
            }
            case 216: {
                return ComparisonExpression.Type.LESS_THAN;
            }
            case 217: {
                return ComparisonExpression.Type.LESS_THAN_OR_EQUAL;
            }
            case 218: {
                return ComparisonExpression.Type.GREATER_THAN;
            }
            case 219: {
                return ComparisonExpression.Type.GREATER_THAN_OR_EQUAL;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + symbol.getText());
    }

    private static IntervalLiteral.IntervalField getIntervalFieldType(Token token) {
        switch (token.getType()) {
            case 60: {
                return IntervalLiteral.IntervalField.YEAR;
            }
            case 61: {
                return IntervalLiteral.IntervalField.MONTH;
            }
            case 62: {
                return IntervalLiteral.IntervalField.DAY;
            }
            case 63: {
                return IntervalLiteral.IntervalField.HOUR;
            }
            case 64: {
                return IntervalLiteral.IntervalField.MINUTE;
            }
            case 65: {
                return IntervalLiteral.IntervalField.SECOND;
            }
        }
        throw new IllegalArgumentException("Unsupported interval field: " + token.getText());
    }

    private static IntervalLiteral.Sign getIntervalSign(Token token) {
        switch (token.getType()) {
            case 221: {
                return IntervalLiteral.Sign.NEGATIVE;
            }
            case 220: {
                return IntervalLiteral.Sign.POSITIVE;
            }
        }
        throw new IllegalArgumentException("Unsupported sign: " + token.getText());
    }

    private static LogicalBinaryExpression.Type getLogicalBinaryOperator(Token token) {
        switch (token.getType()) {
            case 33: {
                return LogicalBinaryExpression.Type.AND;
            }
            case 32: {
                return LogicalBinaryExpression.Type.OR;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + token.getText());
    }

    private static String getType(SqlBaseParser.TypeContext type) {
        if (type.baseType() != null) {
            String signature = AstBuilder.baseTypeToString(type.baseType());
            if (!type.typeParameter().isEmpty()) {
                String typeParameterSignature = type.typeParameter().stream().map(AstBuilder::typeParameterToString).collect(Collectors.joining(","));
                signature = signature + "(" + typeParameterSignature + ")";
            }
            return signature;
        }
        if (type.ARRAY() != null) {
            return "ARRAY(" + AstBuilder.getType(type.type(0)) + ")";
        }
        if (type.MAP() != null) {
            return "MAP(" + AstBuilder.getType(type.type(0)) + "," + AstBuilder.getType(type.type(1)) + ")";
        }
        if (type.ROW() != null) {
            StringBuilder builder = new StringBuilder("(");
            for (int i = 0; i < type.identifier().size(); ++i) {
                if (i != 0) {
                    builder.append(",");
                }
                builder.append(AstBuilder.getIdentifierText(type.identifier(i))).append(" ").append(AstBuilder.getType(type.type(i)));
            }
            builder.append(")");
            return "ROW" + builder.toString();
        }
        throw new IllegalArgumentException("Unsupported type specification: " + type.getText());
    }

    private static String typeParameterToString(SqlBaseParser.TypeParameterContext typeParameter) {
        if (typeParameter.INTEGER_VALUE() != null) {
            return typeParameter.INTEGER_VALUE().toString();
        }
        if (typeParameter.type() != null) {
            return AstBuilder.getType(typeParameter.type());
        }
        throw new IllegalArgumentException("Unsupported typeParameter: " + typeParameter.getText());
    }

    private static String baseTypeToString(SqlBaseParser.BaseTypeContext baseType) {
        if (baseType.identifier() != null) {
            return AstBuilder.getIdentifierText(baseType.identifier());
        }
        throw new KsqlException("Base type must contain either identifier, time with time zone, or timestamp with time zone");
    }

    private static void check(boolean condition, String message, ParserRuleContext context) {
        if (!condition) {
            throw new ParsingException(message, null, context.getStart().getLine(), context.getStart().getCharPositionInLine());
        }
    }

    private static NodeLocation getLocation(TerminalNode terminalNode) {
        Objects.requireNonNull(terminalNode, "terminalNode is null");
        return AstBuilder.getLocation(terminalNode.getSymbol());
    }

    private static NodeLocation getLocation(ParserRuleContext parserRuleContext) {
        Objects.requireNonNull(parserRuleContext, "parserRuleContext is null");
        return AstBuilder.getLocation(parserRuleContext.getStart());
    }

    private static NodeLocation getLocation(Token token) {
        Objects.requireNonNull(token, "token is null");
        return new NodeLocation(token.getLine(), token.getCharPositionInLine());
    }

    private StructuredDataSource getResultDatasource(Select select, Table into) {
        SchemaBuilder dataSource = SchemaBuilder.struct().name(into.toString());
        for (SelectItem selectItem : select.getSelectItems()) {
            if (!(selectItem instanceof SingleColumn)) continue;
            SingleColumn singleColumn = (SingleColumn)selectItem;
            String fieldName = singleColumn.getAlias().get();
            dataSource = dataSource.field(fieldName, Schema.BOOLEAN_SCHEMA);
        }
        KsqlTopic ksqlTopic = new KsqlTopic(into.getName().toString(), into.getName().toString(), null);
        KsqlStream resultStream = new KsqlStream("AstBuilder-Into", into.getName().toString(), dataSource.schema(), (Field)dataSource.fields().get(0), null, ksqlTopic);
        return resultStream;
    }

    private static class InvalidColumnReferenceException
    extends KsqlException {
        public InvalidColumnReferenceException(String message) {
            super(message);
        }

        public InvalidColumnReferenceException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

