/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metastore;

import io.confluent.ksql.metastore.KsqlTopic;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.StructuredDataSource;
import io.confluent.ksql.util.KsqlException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MetaStoreImpl
implements MetaStore,
Cloneable {
    private final Map<String, KsqlTopic> topicMap;
    private final Map<String, StructuredDataSource> dataSourceMap;

    public MetaStoreImpl() {
        this.topicMap = new HashMap<String, KsqlTopic>();
        this.dataSourceMap = new HashMap<String, StructuredDataSource>();
    }

    private MetaStoreImpl(Map<String, KsqlTopic> topicMap, Map<String, StructuredDataSource> dataSourceMap) {
        this.topicMap = topicMap != null ? topicMap : new HashMap();
        this.dataSourceMap = dataSourceMap != null ? dataSourceMap : new HashMap();
    }

    @Override
    public KsqlTopic getTopic(String topicName) {
        return this.topicMap.get(topicName);
    }

    @Override
    public void putTopic(KsqlTopic topic) {
        if (this.topicMap.get(topic.getName()) != null) {
            throw new KsqlException("Cannot add the new topic. Another topic with the same name already exists: " + topic.getName());
        }
        this.topicMap.put(topic.getName(), topic);
    }

    @Override
    public StructuredDataSource getSource(String sourceName) {
        return this.dataSourceMap.get(sourceName);
    }

    @Override
    public void putSource(StructuredDataSource dataSource) {
        if (this.getSource(dataSource.getName()) != null) {
            throw new KsqlException("Cannot add the new data source. Another data source with the same name already exists: " + dataSource.toString());
        }
        this.dataSourceMap.put(dataSource.getName(), dataSource);
    }

    @Override
    public void deleteTopic(String topicName) {
        if (!this.topicMap.containsKey(topicName)) {
            throw new KsqlException(String.format("No topic with name %s was registered.", true));
        }
        this.topicMap.remove(topicName);
    }

    @Override
    public void deleteSource(String sourceName) {
        if (!this.dataSourceMap.containsKey(sourceName)) {
            throw new KsqlException(String.format("No data source with name %s exists.", sourceName));
        }
        this.dataSourceMap.remove(sourceName);
    }

    @Override
    public Map<String, StructuredDataSource> getAllStructuredDataSources() {
        return this.dataSourceMap;
    }

    @Override
    public Set<String> getAllStructuredDataSourceNames() {
        return this.getAllStructuredDataSources().keySet();
    }

    @Override
    public Map<String, KsqlTopic> getAllKsqlTopics() {
        return this.topicMap;
    }

    @Override
    public Set<String> getAllTopicNames() {
        return this.getAllKsqlTopics().keySet();
    }

    @Override
    public void putAll(MetaStore otherMetaStore) {
        this.topicMap.putAll(otherMetaStore.getAllKsqlTopics());
        this.dataSourceMap.putAll(otherMetaStore.getAllStructuredDataSources());
    }

    @Override
    public MetaStore clone() {
        HashMap<String, KsqlTopic> cloneTopicMap = new HashMap<String, KsqlTopic>();
        HashMap<String, StructuredDataSource> cloneDataSourceMap = new HashMap<String, StructuredDataSource>();
        cloneTopicMap.putAll(this.topicMap);
        cloneDataSourceMap.putAll(this.dataSourceMap);
        return new MetaStoreImpl(cloneTopicMap, cloneDataSourceMap);
    }
}

