/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metastore;

import io.confluent.ksql.metastore.KsqlTopic;
import io.confluent.ksql.metastore.StructuredDataSource;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.serde.DataSource;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.SchemaUtil;
import java.util.Optional;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class KsqlTable
extends StructuredDataSource {
    private final String stateStoreName;
    private final boolean isWindowed;

    public KsqlTable(String sqlExpression, String datasourceName, Schema schema, Field keyField, Field timestampField, KsqlTopic ksqlTopic, String stateStoreName, boolean isWindowed) {
        super(sqlExpression, datasourceName, schema, keyField, timestampField, DataSource.DataSourceType.KTABLE, ksqlTopic);
        this.stateStoreName = stateStoreName;
        this.isWindowed = isWindowed;
    }

    public String getStateStoreName() {
        return this.stateStoreName;
    }

    public boolean isWindowed() {
        return this.isWindowed;
    }

    @Override
    public StructuredDataSource cloneWithTimeKeyColumns() {
        Schema newSchema = SchemaUtil.addImplicitRowTimeRowKeyToSchema((Schema)this.schema);
        return new KsqlTable(this.sqlExpression, this.dataSourceName, newSchema, this.keyField, this.timestampField, this.ksqlTopic, this.stateStoreName, this.isWindowed);
    }

    @Override
    public StructuredDataSource cloneWithTimeField(String timestampfieldName) {
        Optional newTimestampField = SchemaUtil.getFieldByName((Schema)this.schema, (String)timestampfieldName);
        if (((Field)newTimestampField.get()).schema().type() != Schema.Type.INT64) {
            throw new KsqlException("Timestamp column, " + timestampfieldName + ", should be LONG" + "(INT64).");
        }
        return new KsqlTable(this.sqlExpression, this.dataSourceName, this.schema, this.keyField, (Field)newTimestampField.get(), this.ksqlTopic, this.stateStoreName, this.isWindowed);
    }

    @Override
    public QueryId getPersistentQueryId() {
        return new QueryId("CTAS_" + this.dataSourceName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " name:" + this.getName();
    }
}

