/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.metastore.KsqlTopic;
import io.confluent.ksql.planner.plan.OutputNode;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.serde.DataSource;
import io.confluent.ksql.util.KafkaTopicClient;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.QueryMetadata;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.Topology;

public class PersistentQueryMetadata
extends QueryMetadata {
    private final QueryId id;
    private final Schema resultSchema;
    private final KsqlTopic resultTopic;

    public PersistentQueryMetadata(String statementString, KafkaStreams kafkaStreams, OutputNode outputNode, String executionPlan, QueryId id, DataSource.DataSourceType dataSourceType, String queryApplicationId, KafkaTopicClient kafkaTopicClient, Schema resultSchema, KsqlTopic resultTopic, Topology topology) {
        super(statementString, kafkaStreams, outputNode, executionPlan, dataSourceType, queryApplicationId, kafkaTopicClient, topology);
        this.id = id;
        this.resultSchema = resultSchema;
        this.resultTopic = resultTopic;
    }

    public QueryId getId() {
        return this.id;
    }

    public Schema getResultSchema() {
        return this.resultSchema;
    }

    public KsqlTopic getResultTopic() {
        return this.resultTopic;
    }

    public String getEntity() {
        return this.getOutputNode().getId().toString();
    }

    public DataSource.DataSourceSerDe getResultTopicSerde() {
        if (this.resultTopic.getKsqlTopicSerDe() == null) {
            throw new KsqlException(String.format("Invalid result topic: %s. Serde cannot be null.", this.resultTopic.getName()));
        }
        return this.resultTopic.getKsqlTopicSerDe().getSerDe();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PersistentQueryMetadata)) {
            return false;
        }
        PersistentQueryMetadata that = (PersistentQueryMetadata)o;
        return Objects.equals(this.id, that.id) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, super.hashCode());
    }
}

