/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.util.KafkaConsumerGroupClient;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.admin.AdminClient;
import kafka.admin.ConsumerGroupCommand;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterator;
import scala.collection.immutable.List;

public class KafkaConsumerGroupClientImpl
implements KafkaConsumerGroupClient {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerGroupClientImpl.class);
    private static final int ADMIN_CLIENT_TIMEOUT_MS = 1000;
    private final AdminClient adminClient;
    private final KsqlConfig ksqlConfig;

    public KafkaConsumerGroupClientImpl(KsqlConfig ksqlConfig) {
        this.ksqlConfig = ksqlConfig;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)ksqlConfig.getKsqlAdminClientConfigProps());
        this.adminClient = AdminClient.create((Properties)props);
    }

    @Override
    public java.util.List<String> listGroups() {
        String[] args = this.consumerGroupCommandOptions();
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(args);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupService = new ConsumerGroupCommand.KafkaConsumerGroupService(opts);
        List consumerGroups = consumerGroupService.listGroups();
        Iterator consumerGroupsIterator = consumerGroups.iterator();
        ArrayList<String> results = new ArrayList<String>();
        while (consumerGroupsIterator.hasNext()) {
            results.add((String)consumerGroupsIterator.next());
        }
        return results;
    }

    private String[] consumerGroupCommandOptions() {
        Map clientConfigProps = this.ksqlConfig.getKsqlAdminClientConfigProps();
        try {
            File tmpConfigFile = this.flushPropertiesToTempFile(clientConfigProps);
            String[] args = new String[]{"--bootstrap-server", (String)clientConfigProps.get("bootstrap.servers"), "--command-config", tmpConfigFile.getAbsolutePath()};
            return args;
        }
        catch (IOException e) {
            log.error("Could not configure the list groups command.", (Throwable)e);
            throw new KsqlException("Could not list groups", (Throwable)e);
        }
    }

    private File flushPropertiesToTempFile(Map<String, Object> configProps) throws IOException {
        FileAttribute<Set<PosixFilePermission>> attributes = PosixFilePermissions.asFileAttribute(new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ)));
        File configFile = Files.createTempFile("ksqlclient", "properties", attributes).toFile();
        configFile.deleteOnExit();
        try (FileOutputStream outputStream = new FileOutputStream(configFile);){
            Properties clientProps = new Properties();
            for (Map.Entry<String, Object> property : configProps.entrySet()) {
                clientProps.put(property.getKey(), property.getValue());
            }
            clientProps.store(outputStream, "Configuration properties of KSQL AdminClient");
        }
        return configFile;
    }

    @Override
    public void close() {
        this.adminClient.close();
    }

    @Override
    public KafkaConsumerGroupClient.ConsumerGroupSummary describeConsumerGroup(String group) {
        AdminClient.ConsumerGroupSummary consumerGroupSummary = this.adminClient.describeConsumerGroup(group, 1000L);
        List consumerSummaryList = (List)consumerGroupSummary.consumers().get();
        Iterator consumerSummaryIterator = consumerSummaryList.iterator();
        KafkaConsumerGroupClient.ConsumerGroupSummary results = new KafkaConsumerGroupClient.ConsumerGroupSummary();
        while (consumerSummaryIterator.hasNext()) {
            AdminClient.ConsumerSummary consumerSummary = (AdminClient.ConsumerSummary)consumerSummaryIterator.next();
            KafkaConsumerGroupClient.ConsumerSummary consumerSummary1 = new KafkaConsumerGroupClient.ConsumerSummary(consumerSummary.consumerId());
            results.addConsumerSummary(consumerSummary1);
            List topicPartitionList = consumerSummary.assignment();
            for (TopicPartition topicPartition : topicPartitionList) {
                consumerSummary1.addPartition(new TopicPartition(topicPartition.topic(), topicPartition.partition()));
            }
        }
        return results;
    }
}

