/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.util.KsqlException;
import java.util.List;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class GenericRowValueTypeEnforcer {
    private final List<Field> fields;

    public GenericRowValueTypeEnforcer(Schema schema) {
        this.fields = schema.fields();
    }

    public Object enforceFieldType(int index, Object value) {
        Field field = this.fields.get(index);
        return this.enforceFieldType(field.schema(), value);
    }

    private Object enforceFieldType(Schema schema, Object value) {
        switch (schema.type()) {
            case INT32: {
                return this.enforceInteger(value);
            }
            case INT64: {
                return this.enforceLong(value);
            }
            case FLOAT64: {
                return this.enforceDouble(value);
            }
            case STRING: {
                return this.enforceString(value);
            }
            case BOOLEAN: {
                return this.enforceBoolean(value);
            }
            case ARRAY: {
                return value;
            }
            case MAP: {
                return value;
            }
        }
        throw new KsqlException("Type is not supported: " + schema);
    }

    private Double enforceDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Short) {
            return ((Short)value).doubleValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).doubleValue();
        }
        if (value instanceof String || value instanceof CharSequence) {
            return Double.parseDouble(value.toString());
        }
        if (value == null) {
            return null;
        }
        throw new KsqlException("Invalid field type. Value must be Double.");
    }

    private Long enforceLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Float) {
            return ((Float)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof String || value instanceof CharSequence) {
            return Long.parseLong(value.toString());
        }
        if (value == null) {
            return null;
        }
        throw new KsqlException("Invalid field type. Value must be Long.");
    }

    private Integer enforceInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof Float) {
            return ((Float)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof String || value instanceof CharSequence) {
            return Integer.parseInt(value.toString());
        }
        if (value == null) {
            return null;
        }
        throw new KsqlException("Invalid field type. Value must be Integer.");
    }

    private String enforceString(Object value) {
        if (value instanceof String || value instanceof CharSequence) {
            return value.toString();
        }
        if (value == null) {
            return null;
        }
        throw new KsqlException("Invalid field type. Value must be String.");
    }

    private Boolean enforceBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean(value.toString());
        }
        if (value == null) {
            return null;
        }
        throw new KsqlException("Invalid field type. Value must be Boolean.");
    }
}

