/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.function.KsqlFunction;
import io.confluent.ksql.parser.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.parser.tree.BooleanLiteral;
import io.confluent.ksql.parser.tree.Cast;
import io.confluent.ksql.parser.tree.ComparisonExpression;
import io.confluent.ksql.parser.tree.DefaultAstVisitor;
import io.confluent.ksql.parser.tree.DereferenceExpression;
import io.confluent.ksql.parser.tree.DoubleLiteral;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.FunctionCall;
import io.confluent.ksql.parser.tree.IsNotNullPredicate;
import io.confluent.ksql.parser.tree.IsNullPredicate;
import io.confluent.ksql.parser.tree.LikePredicate;
import io.confluent.ksql.parser.tree.LongLiteral;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.QualifiedNameReference;
import io.confluent.ksql.parser.tree.StringLiteral;
import io.confluent.ksql.parser.tree.SubscriptExpression;
import io.confluent.ksql.planner.PlanException;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.SchemaUtil;
import java.util.Optional;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class ExpressionTypeManager
extends DefaultAstVisitor<Expression, ExpressionTypeContext> {
    private final Schema schema;
    private final FunctionRegistry functionRegistry;

    public ExpressionTypeManager(Schema schema, FunctionRegistry functionRegistry) {
        this.schema = schema;
        this.functionRegistry = functionRegistry;
    }

    public Schema getExpressionType(Expression expression) {
        ExpressionTypeContext expressionTypeContext = new ExpressionTypeContext();
        this.process((Node)expression, expressionTypeContext);
        return expressionTypeContext.getSchema();
    }

    protected Expression visitArithmeticBinary(ArithmeticBinaryExpression node, ExpressionTypeContext expressionTypeContext) {
        this.process((Node)node.getLeft(), expressionTypeContext);
        Schema leftType = expressionTypeContext.getSchema();
        this.process((Node)node.getRight(), expressionTypeContext);
        Schema rightType = expressionTypeContext.getSchema();
        expressionTypeContext.setSchema(this.resolveArithmaticType(leftType, rightType));
        return null;
    }

    protected Expression visitCast(Cast node, ExpressionTypeContext expressionTypeContext) {
        Schema castType = SchemaUtil.getTypeSchema((String)node.getType());
        expressionTypeContext.setSchema(castType);
        return null;
    }

    protected Expression visitComparisonExpression(ComparisonExpression node, ExpressionTypeContext expressionTypeContext) {
        expressionTypeContext.setSchema(Schema.BOOLEAN_SCHEMA);
        return null;
    }

    protected Expression visitQualifiedNameReference(QualifiedNameReference node, ExpressionTypeContext expressionTypeContext) {
        Optional schemaField = SchemaUtil.getFieldByName((Schema)this.schema, (String)node.getName().getSuffix());
        if (!schemaField.isPresent()) {
            throw new KsqlException(String.format("Invalid Expression %s.", node.toString()));
        }
        expressionTypeContext.setSchema(((Field)schemaField.get()).schema());
        return null;
    }

    protected Expression visitDereferenceExpression(DereferenceExpression node, ExpressionTypeContext expressionTypeContext) {
        Optional schemaField = SchemaUtil.getFieldByName((Schema)this.schema, (String)node.toString());
        if (!schemaField.isPresent()) {
            throw new KsqlException(String.format("Invalid Expression %s.", node.toString()));
        }
        expressionTypeContext.setSchema(((Field)schemaField.get()).schema());
        return null;
    }

    protected Expression visitStringLiteral(StringLiteral node, ExpressionTypeContext expressionTypeContext) {
        expressionTypeContext.setSchema(Schema.STRING_SCHEMA);
        return null;
    }

    protected Expression visitBooleanLiteral(BooleanLiteral node, ExpressionTypeContext expressionTypeContext) {
        expressionTypeContext.setSchema(Schema.BOOLEAN_SCHEMA);
        return null;
    }

    protected Expression visitLongLiteral(LongLiteral node, ExpressionTypeContext expressionTypeContext) {
        expressionTypeContext.setSchema(Schema.INT64_SCHEMA);
        return null;
    }

    protected Expression visitDoubleLiteral(DoubleLiteral node, ExpressionTypeContext expressionTypeContext) {
        expressionTypeContext.setSchema(Schema.FLOAT64_SCHEMA);
        return null;
    }

    protected Expression visitLikePredicate(LikePredicate node, ExpressionTypeContext expressionTypeContext) {
        expressionTypeContext.setSchema(Schema.BOOLEAN_SCHEMA);
        return null;
    }

    protected Expression visitIsNotNullPredicate(IsNotNullPredicate node, ExpressionTypeContext expressionTypeContext) {
        expressionTypeContext.setSchema(Schema.BOOLEAN_SCHEMA);
        return null;
    }

    protected Expression visitIsNullPredicate(IsNullPredicate node, ExpressionTypeContext expressionTypeContext) {
        expressionTypeContext.setSchema(Schema.BOOLEAN_SCHEMA);
        return null;
    }

    protected Expression visitSubscriptExpression(SubscriptExpression node, ExpressionTypeContext expressionTypeContext) {
        String arrayBaseName = node.getBase().toString();
        Optional schemaField = SchemaUtil.getFieldByName((Schema)this.schema, (String)arrayBaseName);
        if (!schemaField.isPresent()) {
            throw new KsqlException(String.format("Invalid Expression %s.", node.toString()));
        }
        expressionTypeContext.setSchema(((Field)schemaField.get()).schema().valueSchema());
        return null;
    }

    protected Expression visitFunctionCall(FunctionCall node, ExpressionTypeContext expressionTypeContext) {
        KsqlFunction ksqlFunction = this.functionRegistry.getFunction(node.getName().getSuffix());
        if (ksqlFunction != null) {
            expressionTypeContext.setSchema(ksqlFunction.getReturnType());
        } else if (this.functionRegistry.isAnAggregateFunction(node.getName().getSuffix())) {
            KsqlAggregateFunction ksqlAggregateFunction = this.functionRegistry.getAggregateFunction(node.getName().getSuffix(), node.getArguments(), this.schema);
            expressionTypeContext.setSchema(ksqlAggregateFunction.getReturnType());
        } else {
            throw new KsqlException("Unknown function: " + node.getName().toString());
        }
        return null;
    }

    private Schema resolveArithmaticType(Schema leftSchema, Schema rightSchema) {
        Schema.Type rightType;
        Schema.Type leftType = leftSchema.type();
        if (leftType == (rightType = rightSchema.type())) {
            return leftSchema;
        }
        if (leftType == Schema.Type.STRING || rightType == Schema.Type.STRING || leftType == Schema.Type.BOOLEAN || rightType == Schema.Type.BOOLEAN) {
            throw new PlanException("Incompatible types.");
        }
        if (leftType == Schema.Type.FLOAT64 || rightType == Schema.Type.FLOAT64) {
            return Schema.FLOAT64_SCHEMA;
        }
        if (leftType == Schema.Type.INT64 || rightType == Schema.Type.INT64) {
            return Schema.INT64_SCHEMA;
        }
        if (leftType == Schema.Type.INT32 || rightType == Schema.Type.INT32) {
            return Schema.INT32_SCHEMA;
        }
        throw new PlanException("Unsupported types.");
    }

    static class ExpressionTypeContext {
        Schema schema;

        ExpressionTypeContext() {
        }

        public Schema getSchema() {
            return this.schema;
        }

        public void setSchema(Schema schema) {
            this.schema = schema;
        }
    }
}

