/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.MetastoreUtil;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.PlanVisitor;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.util.KafkaTopicClient;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.StreamsBuilder;

@Immutable
public class ProjectNode
extends PlanNode {
    private final PlanNode source;
    private final Schema schema;
    private final Field keyField;
    private final List<Expression> projectExpressions;

    @JsonCreator
    public ProjectNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="schema") Schema schema, @JsonProperty(value="projectExpressions") List<Expression> projectExpressions) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(projectExpressions, "projectExpressions is null");
        this.source = source;
        this.schema = schema;
        this.keyField = source.getKeyField();
        this.projectExpressions = projectExpressions;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Field getKeyField() {
        return this.keyField;
    }

    public List<Pair<String, Expression>> getProjectNameExpressionPairList() {
        if (this.schema.fields().size() != this.projectExpressions.size()) {
            throw new KsqlException("Error in projection. Schema fields and expression list are not compatible.");
        }
        ArrayList<Pair<String, Expression>> expressionPairs = new ArrayList<Pair<String, Expression>>();
        for (int i = 0; i < this.projectExpressions.size(); ++i) {
            expressionPairs.add((Pair<String, Expression>)new Pair((Object)((Field)this.schema.fields().get(i)).name(), (Object)this.projectExpressions.get(i)));
        }
        return expressionPairs;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitProject(this, context);
    }

    @Override
    public SchemaKStream buildStream(StreamsBuilder builder, KsqlConfig ksqlConfig, KafkaTopicClient kafkaTopicClient, MetastoreUtil metastoreUtil, FunctionRegistry functionRegistry, Map<String, Object> props, SchemaRegistryClient schemaRegistryClient) {
        return this.getSource().buildStream(builder, ksqlConfig, kafkaTopicClient, metastoreUtil, functionRegistry, props, schemaRegistryClient).select(this.getProjectNameExpressionPairList());
    }
}

