/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.MetastoreUtil;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.PlanVisitor;
import io.confluent.ksql.planner.plan.StructuredDataSourceNode;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.util.KafkaTopicClient;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.StreamsBuilder;

public abstract class PlanNode {
    private final PlanNodeId id;

    protected PlanNode(PlanNodeId id) {
        Objects.requireNonNull(id, "id is null");
        this.id = id;
    }

    @JsonProperty(value="id")
    public PlanNodeId getId() {
        return this.id;
    }

    public abstract Schema getSchema();

    public abstract Field getKeyField();

    public abstract List<PlanNode> getSources();

    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitPlan(this, context);
    }

    public StructuredDataSourceNode getTheSourceNode() {
        if (this instanceof StructuredDataSourceNode) {
            return (StructuredDataSourceNode)this;
        }
        if (this.getSources() != null && !this.getSources().isEmpty()) {
            return this.getSources().get(0).getTheSourceNode();
        }
        return null;
    }

    public abstract SchemaKStream buildStream(StreamsBuilder var1, KsqlConfig var2, KafkaTopicClient var3, MetastoreUtil var4, FunctionRegistry var5, Map<String, Object> var6, SchemaRegistryClient var7);
}

