/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner;

import io.confluent.ksql.analyzer.AggregateAnalysis;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.KsqlStdOut;
import io.confluent.ksql.metastore.KsqlStream;
import io.confluent.ksql.metastore.KsqlTable;
import io.confluent.ksql.metastore.StructuredDataSource;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.planner.plan.AggregateNode;
import io.confluent.ksql.planner.plan.FilterNode;
import io.confluent.ksql.planner.plan.KsqlBareOutputNode;
import io.confluent.ksql.planner.plan.KsqlStructuredDataOutputNode;
import io.confluent.ksql.planner.plan.OutputNode;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.ProjectNode;
import io.confluent.ksql.planner.plan.StructuredDataSourceNode;
import io.confluent.ksql.util.ExpressionTypeManager;
import io.confluent.ksql.util.Pair;
import io.confluent.ksql.util.SchemaUtil;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class LogicalPlanner {
    private Analysis analysis;
    private AggregateAnalysis aggregateAnalysis;
    private final FunctionRegistry functionRegistry;

    public LogicalPlanner(Analysis analysis, AggregateAnalysis aggregateAnalysis, FunctionRegistry functionRegistry) {
        this.analysis = analysis;
        this.aggregateAnalysis = aggregateAnalysis;
        this.functionRegistry = functionRegistry;
    }

    public PlanNode buildPlan() {
        PlanNode currentNode = this.analysis.getJoin() != null ? this.analysis.getJoin() : this.buildSourceNode();
        if (this.analysis.getWhereExpression() != null) {
            currentNode = this.buildFilterNode(currentNode);
        }
        currentNode = this.analysis.getGroupByExpressions() != null && !this.analysis.getGroupByExpressions().isEmpty() ? this.buildAggregateNode(currentNode.getSchema(), currentNode) : this.buildProjectNode(currentNode.getSchema(), currentNode);
        return this.buildOutputNode(currentNode.getSchema(), currentNode);
    }

    private OutputNode buildOutputNode(Schema inputSchema, PlanNode sourcePlanNode) {
        StructuredDataSource intoDataSource = this.analysis.getInto();
        if (intoDataSource instanceof KsqlStdOut) {
            return new KsqlBareOutputNode(new PlanNodeId("KSQL_STDOUT_NAME"), sourcePlanNode, inputSchema, this.analysis.getLimitClause());
        }
        if (intoDataSource != null) {
            Field timestampField = null;
            if (this.analysis.getIntoProperties().get("TIMESTAMP") != null) {
                timestampField = (Field)SchemaUtil.getFieldByName((Schema)inputSchema, (String)this.analysis.getIntoProperties().get("TIMESTAMP").toString()).get();
            }
            return new KsqlStructuredDataOutputNode(new PlanNodeId(intoDataSource.getName()), sourcePlanNode, inputSchema, timestampField, sourcePlanNode.getKeyField(), intoDataSource.getKsqlTopic(), intoDataSource.getKsqlTopic().getTopicName(), this.analysis.getIntoProperties(), this.analysis.getLimitClause());
        }
        throw new RuntimeException("INTO clause is not supported in SELECT.");
    }

    private AggregateNode buildAggregateNode(Schema inputSchema, PlanNode sourcePlanNode) {
        SchemaBuilder aggregateSchema = SchemaBuilder.struct();
        ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(inputSchema, this.functionRegistry);
        for (int i = 0; i < this.analysis.getSelectExpressions().size(); ++i) {
            Expression expression = this.analysis.getSelectExpressions().get(i);
            String alias = this.analysis.getSelectExpressionAlias().get(i);
            Schema expressionType = expressionTypeManager.getExpressionType(expression);
            aggregateSchema = aggregateSchema.field(alias, expressionType);
        }
        return new AggregateNode(new PlanNodeId("Aggregate"), sourcePlanNode, (Schema)aggregateSchema, this.analysis.getGroupByExpressions(), this.analysis.getWindowExpression(), this.aggregateAnalysis.getAggregateFunctionArguments(), this.aggregateAnalysis.getFunctionList(), this.aggregateAnalysis.getRequiredColumnsList(), this.aggregateAnalysis.getFinalSelectExpressions(), this.aggregateAnalysis.getHavingExpression());
    }

    private ProjectNode buildProjectNode(Schema inputSchema, PlanNode sourcePlanNode) {
        SchemaBuilder projectionSchema = SchemaBuilder.struct();
        ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(inputSchema, this.functionRegistry);
        for (int i = 0; i < this.analysis.getSelectExpressions().size(); ++i) {
            Expression expression = this.analysis.getSelectExpressions().get(i);
            String alias = this.analysis.getSelectExpressionAlias().get(i);
            Schema expressionType = expressionTypeManager.getExpressionType(expression);
            projectionSchema = projectionSchema.field(alias, expressionType);
        }
        return new ProjectNode(new PlanNodeId("Project"), sourcePlanNode, (Schema)projectionSchema, this.analysis.getSelectExpressions());
    }

    private FilterNode buildFilterNode(PlanNode sourcePlanNode) {
        Expression filterExpression = this.analysis.getWhereExpression();
        return new FilterNode(new PlanNodeId("Filter"), sourcePlanNode, filterExpression);
    }

    private StructuredDataSourceNode buildSourceNode() {
        Pair<StructuredDataSource, String> dataSource = this.analysis.getFromDataSource(0);
        Schema fromSchema = SchemaUtil.buildSchemaWithAlias((Schema)((StructuredDataSource)dataSource.left).getSchema(), (String)((String)dataSource.right));
        if (dataSource.left instanceof KsqlStream || dataSource.left instanceof KsqlTable) {
            return new StructuredDataSourceNode(new PlanNodeId("KsqlTopic"), (StructuredDataSource)dataSource.left, fromSchema);
        }
        throw new RuntimeException("Data source is not supported yet.");
    }
}

