/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner;

import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.ArithmeticBinaryExpression;
import io.confluent.ksql.parser.tree.ArithmeticUnaryExpression;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.BetweenPredicate;
import io.confluent.ksql.parser.tree.Cast;
import io.confluent.ksql.parser.tree.ComparisonExpression;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.Delete;
import io.confluent.ksql.parser.tree.DereferenceExpression;
import io.confluent.ksql.parser.tree.Expression;
import io.confluent.ksql.parser.tree.Extract;
import io.confluent.ksql.parser.tree.FrameBound;
import io.confluent.ksql.parser.tree.FunctionCall;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.GroupingElement;
import io.confluent.ksql.parser.tree.InListExpression;
import io.confluent.ksql.parser.tree.InPredicate;
import io.confluent.ksql.parser.tree.IsNotNullPredicate;
import io.confluent.ksql.parser.tree.IsNullPredicate;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinOn;
import io.confluent.ksql.parser.tree.LikePredicate;
import io.confluent.ksql.parser.tree.LogicalBinaryExpression;
import io.confluent.ksql.parser.tree.Node;
import io.confluent.ksql.parser.tree.NotExpression;
import io.confluent.ksql.parser.tree.NullIfExpression;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.QuerySpecification;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.Row;
import io.confluent.ksql.parser.tree.SampledRelation;
import io.confluent.ksql.parser.tree.SearchedCaseExpression;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SetOperation;
import io.confluent.ksql.parser.tree.SimpleCaseExpression;
import io.confluent.ksql.parser.tree.SimpleGroupBy;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.Statements;
import io.confluent.ksql.parser.tree.SubqueryExpression;
import io.confluent.ksql.parser.tree.SubscriptExpression;
import io.confluent.ksql.parser.tree.TableSubquery;
import io.confluent.ksql.parser.tree.Values;
import io.confluent.ksql.parser.tree.WhenClause;
import io.confluent.ksql.parser.tree.Window;
import io.confluent.ksql.parser.tree.WindowFrame;
import io.confluent.ksql.parser.tree.WithQuery;
import java.util.List;
import java.util.Set;

public abstract class DefaultTraversalVisitor<R, C>
extends AstVisitor<R, C> {
    protected R visitStatements(Statements node, C context) {
        for (Statement statement : node.statementList) {
            this.process((Node)statement, context);
        }
        return (R)this.visitNode((Node)node, context);
    }

    protected R visitExtract(Extract node, C context) {
        return (R)this.process((Node)node.getExpression(), context);
    }

    protected R visitCast(Cast node, C context) {
        return (R)this.process((Node)node.getExpression(), context);
    }

    protected R visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
        this.process((Node)node.getLeft(), context);
        this.process((Node)node.getRight(), context);
        return null;
    }

    protected R visitBetweenPredicate(BetweenPredicate node, C context) {
        this.process((Node)node.getValue(), context);
        this.process((Node)node.getMin(), context);
        this.process((Node)node.getMax(), context);
        return null;
    }

    protected R visitSubscriptExpression(SubscriptExpression node, C context) {
        this.process((Node)node.getBase(), context);
        this.process((Node)node.getIndex(), context);
        return null;
    }

    protected R visitComparisonExpression(ComparisonExpression node, C context) {
        this.process((Node)node.getLeft(), context);
        this.process((Node)node.getRight(), context);
        return null;
    }

    protected R visitQuery(Query node, C context) {
        this.process((Node)node.getQueryBody(), context);
        return null;
    }

    protected R visitWithQuery(WithQuery node, C context) {
        return (R)this.process((Node)node.getQuery(), context);
    }

    protected R visitSelect(Select node, C context) {
        for (SelectItem item : node.getSelectItems()) {
            this.process((Node)item, context);
        }
        return null;
    }

    protected R visitSingleColumn(SingleColumn node, C context) {
        this.process((Node)node.getExpression(), context);
        return null;
    }

    protected R visitWhenClause(WhenClause node, C context) {
        this.process((Node)node.getOperand(), context);
        this.process((Node)node.getResult(), context);
        return null;
    }

    protected R visitInPredicate(InPredicate node, C context) {
        this.process((Node)node.getValue(), context);
        this.process((Node)node.getValueList(), context);
        return null;
    }

    protected R visitFunctionCall(FunctionCall node, C context) {
        for (Expression argument : node.getArguments()) {
            this.process((Node)argument, context);
        }
        if (node.getWindow().isPresent()) {
            this.process((Node)node.getWindow().get(), context);
        }
        return null;
    }

    protected R visitDereferenceExpression(DereferenceExpression node, C context) {
        this.process((Node)node.getBase(), context);
        return null;
    }

    public R visitWindow(Window node, C context) {
        this.process((Node)node.getWindowExpression(), context);
        return null;
    }

    public R visitWindowFrame(WindowFrame node, C context) {
        this.process((Node)node.getStart(), context);
        if (node.getEnd().isPresent()) {
            this.process((Node)node.getEnd().get(), context);
        }
        return null;
    }

    public R visitFrameBound(FrameBound node, C context) {
        if (node.getValue().isPresent()) {
            this.process((Node)node.getValue().get(), context);
        }
        return null;
    }

    protected R visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
        this.process((Node)node.getOperand(), context);
        for (WhenClause clause : node.getWhenClauses()) {
            this.process((Node)clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    protected R visitInListExpression(InListExpression node, C context) {
        for (Expression value : node.getValues()) {
            this.process((Node)value, context);
        }
        return null;
    }

    protected R visitNullIfExpression(NullIfExpression node, C context) {
        this.process((Node)node.getFirst(), context);
        this.process((Node)node.getSecond(), context);
        return null;
    }

    protected R visitArithmeticUnary(ArithmeticUnaryExpression node, C context) {
        return (R)this.process((Node)node.getValue(), context);
    }

    protected R visitNotExpression(NotExpression node, C context) {
        return (R)this.process((Node)node.getValue(), context);
    }

    protected R visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
        for (WhenClause clause : node.getWhenClauses()) {
            this.process((Node)clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    protected R visitLikePredicate(LikePredicate node, C context) {
        this.process((Node)node.getValue(), context);
        this.process((Node)node.getPattern(), context);
        if (node.getEscape() != null) {
            this.process((Node)node.getEscape(), context);
        }
        return null;
    }

    protected R visitIsNotNullPredicate(IsNotNullPredicate node, C context) {
        return (R)this.process((Node)node.getValue(), context);
    }

    protected R visitIsNullPredicate(IsNullPredicate node, C context) {
        return (R)this.process((Node)node.getValue(), context);
    }

    protected R visitLogicalBinaryExpression(LogicalBinaryExpression node, C context) {
        this.process((Node)node.getLeft(), context);
        this.process((Node)node.getRight(), context);
        return null;
    }

    protected R visitSubqueryExpression(SubqueryExpression node, C context) {
        return (R)this.process((Node)node.getQuery(), context);
    }

    protected R visitQuerySpecification(QuerySpecification node, C context) {
        this.process((Node)node.getSelect(), context);
        this.process((Node)node.getFrom(), context);
        if (node.getWhere().isPresent()) {
            this.process((Node)node.getWhere().get(), context);
        }
        if (node.getGroupBy().isPresent()) {
            this.process((Node)node.getGroupBy().get(), context);
        }
        if (node.getHaving().isPresent()) {
            this.process((Node)node.getHaving().get(), context);
        }
        return null;
    }

    protected R visitSetOperation(SetOperation node, C context) {
        for (Relation relation : node.getRelations()) {
            this.process((Node)relation, context);
        }
        return null;
    }

    protected R visitValues(Values node, C context) {
        for (Expression row : node.getRows()) {
            this.process((Node)row, context);
        }
        return null;
    }

    protected R visitRow(Row node, C context) {
        for (Expression expression : node.getItems()) {
            this.process((Node)expression, context);
        }
        return null;
    }

    protected R visitTableSubquery(TableSubquery node, C context) {
        return (R)this.process((Node)node.getQuery(), context);
    }

    protected R visitAliasedRelation(AliasedRelation node, C context) {
        return (R)this.process((Node)node.getRelation(), context);
    }

    protected R visitSampledRelation(SampledRelation node, C context) {
        this.process((Node)node.getRelation(), context);
        this.process((Node)node.getSamplePercentage(), context);
        if (node.getColumnsToStratifyOn().isPresent()) {
            for (Expression expression : (List)node.getColumnsToStratifyOn().get()) {
                this.process((Node)expression, context);
            }
        }
        return null;
    }

    protected R visitJoin(Join node, C context) {
        this.process((Node)node.getLeft(), context);
        this.process((Node)node.getRight(), context);
        node.getCriteria().filter(criteria -> criteria instanceof JoinOn).map(criteria -> this.process((Node)((JoinOn)criteria).getExpression(), context));
        return null;
    }

    protected R visitGroupBy(GroupBy node, C context) {
        for (GroupingElement groupingElement : node.getGroupingElements()) {
            this.process((Node)groupingElement, context);
        }
        return null;
    }

    protected R visitGroupingElement(GroupingElement node, C context) {
        for (Set expressions : node.enumerateGroupingSets()) {
            for (Expression expression : expressions) {
                this.process((Node)expression, context);
            }
        }
        return null;
    }

    protected R visitSimpleGroupBy(SimpleGroupBy node, C context) {
        this.visitGroupingElement((GroupingElement)node, context);
        for (Expression expression : node.getColumnExpressions()) {
            this.process((Node)expression, context);
        }
        return null;
    }

    protected R visitDelete(Delete node, C context) {
        this.process((Node)node.getTable(), context);
        node.getWhere().ifPresent(where -> this.process((Node)where, context));
        return null;
    }

    protected R visitCreateTableAsSelect(CreateTableAsSelect node, C context) {
        this.process((Node)node.getQuery(), context);
        node.getProperties().values().forEach(expression -> this.process((Node)expression, context));
        return null;
    }
}

