/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.util.json.JsonPathTokenizer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class JsonExtractStringKudf
implements Kudf {
    private static final ObjectReader OBJECT_READER = new ObjectMapper().reader();
    private List<String> tokens = null;

    @Override
    public Object evaluate(Object ... args) {
        if (args.length != 2) {
            throw new KsqlFunctionException("getStringFromJson udf should have two input arguments: JSON document and JSON path.");
        }
        this.ensureInitialized(args);
        JsonNode currentNode = JsonExtractStringKudf.parseJsonDoc(args[0]);
        for (String token : this.tokens) {
            if (currentNode instanceof ArrayNode) {
                try {
                    int index = Integer.parseInt(token);
                    currentNode = currentNode.get(index);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            } else {
                currentNode = currentNode.get(token);
            }
            if (currentNode != null) continue;
            return null;
        }
        if (currentNode.isTextual()) {
            return currentNode.asText();
        }
        return currentNode.toString();
    }

    private void ensureInitialized(Object[] args) {
        if (this.tokens != null) {
            return;
        }
        String path = args[1].toString();
        JsonPathTokenizer tokenizer = new JsonPathTokenizer(path);
        this.tokens = ImmutableList.copyOf((Iterator)((Object)tokenizer));
    }

    private static JsonNode parseJsonDoc(Object arg) {
        String jsonString = arg.toString();
        try {
            return OBJECT_READER.readTree(jsonString);
        }
        catch (IOException e) {
            throw new KsqlFunctionException("Invalid JSON format:" + jsonString, e);
        }
    }
}

