/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Kudf;
import io.confluent.ksql.util.ArrayUtil;
import io.confluent.ksql.util.KsqlException;
import java.io.IOException;
import java.util.Arrays;

public class ArrayContainsKudf
implements Kudf {
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    @Override
    public Object evaluate(Object ... args) {
        if (args.length != 2) {
            throw new KsqlFunctionException("ARRAY_CONTAINS udf should have two input argument. Given: " + Arrays.toString(args));
        }
        Object searchValue = args[1];
        if (args[0] instanceof String) {
            return this.jsonStringArrayContains(searchValue, (String)args[0]);
        }
        if (args[0] instanceof Object[]) {
            return ArrayUtil.containsValue(searchValue, (Object[])args[0]);
        }
        throw new KsqlFunctionException("Invalid type parameters for " + Arrays.toString(args));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean jsonStringArrayContains(Object searchValue, String jsonArray) {
        JsonToken valueType = this.getType(searchValue);
        try (JsonParser parser = JSON_FACTORY.createParser(jsonArray);){
            block51: {
                if (parser.nextToken() != JsonToken.START_ARRAY) {
                    boolean bl = false;
                    return bl;
                }
                while (parser.currentToken() != null) {
                    JsonToken token = parser.nextToken();
                    if (token == null) {
                        boolean bl = searchValue == null;
                        return bl;
                    }
                    if (token == JsonToken.END_ARRAY) {
                        boolean bl = false;
                        return bl;
                    }
                    parser.skipChildren();
                    if (valueType != token) continue;
                    if (valueType == JsonToken.VALUE_NULL && searchValue == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (valueType == JsonToken.VALUE_STRING && parser.getText().equals(searchValue)) {
                        boolean bl = true;
                        return bl;
                    }
                    if ((valueType == JsonToken.VALUE_FALSE || valueType == JsonToken.VALUE_TRUE) && parser.getBooleanValue() == ((Boolean)searchValue).booleanValue()) {
                        boolean bl = true;
                        return bl;
                    }
                    if (valueType == JsonToken.VALUE_NUMBER_INT) {
                        if (searchValue instanceof Integer && parser.getIntValue() == ((Integer)searchValue).intValue()) {
                            boolean bl = true;
                            return bl;
                        }
                        if (!(searchValue instanceof Long) || parser.getLongValue() != ((Long)searchValue).longValue()) continue;
                        boolean bl = true;
                        return bl;
                    }
                    if (valueType != JsonToken.VALUE_NUMBER_FLOAT || parser.getDoubleValue() != ((Double)searchValue).doubleValue()) {
                        continue;
                    }
                    break block51;
                }
                return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new KsqlException("Invalid JSON format: " + jsonArray, (Throwable)e);
        }
    }

    private JsonToken getType(Object searchValue) {
        if (searchValue instanceof Long || searchValue instanceof Integer) {
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (searchValue instanceof Double) {
            return JsonToken.VALUE_NUMBER_FLOAT;
        }
        if (searchValue instanceof String) {
            return JsonToken.VALUE_STRING;
        }
        if (searchValue == null) {
            return JsonToken.VALUE_NULL;
        }
        if (searchValue instanceof Boolean) {
            boolean value = (Boolean)searchValue;
            return value ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
        }
        throw new KsqlFunctionException("Invalid Type for search value " + searchValue);
    }
}

