/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Kudf;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;

public class StringToTimestamp
implements Kudf {
    private DateTimeFormatter threadSafeFormatter;

    @Override
    public Object evaluate(Object ... args) {
        if (args.length != 2) {
            throw new KsqlFunctionException("StringToTimestamp udf should have two input argument: date value and format.");
        }
        try {
            this.ensureInitialized(args);
            TemporalAccessor parsed = this.threadSafeFormatter.parseBest(args[0].toString(), ZonedDateTime::from, LocalDateTime::from);
            if (parsed == null) {
                throw new KsqlFunctionException("Value could not be parsed");
            }
            if (parsed instanceof ZonedDateTime) {
                parsed = ((ZonedDateTime)parsed).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
            }
            LocalDateTime dateTime = (LocalDateTime)parsed;
            return Timestamp.valueOf(dateTime).getTime();
        }
        catch (Exception e) {
            throw new KsqlFunctionException("Exception running StringToTimestamp(" + args[0] + ", " + args[1] + ") : " + e.getMessage(), e);
        }
    }

    private void ensureInitialized(Object[] args) {
        if (this.threadSafeFormatter == null) {
            this.threadSafeFormatter = new DateTimeFormatterBuilder().appendPattern(args[1].toString()).parseDefaulting(ChronoField.YEAR_OF_ERA, 1970L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).toFormatter();
        }
    }
}

