/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.topkdistinct;

import io.confluent.ksql.function.AggregateFunctionFactory;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.function.udaf.topkdistinct.TopkDistinctKudaf;
import io.confluent.ksql.util.KsqlException;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.connect.data.Schema;

public class TopkDistinctAggFunctionFactory
extends AggregateFunctionFactory {
    public TopkDistinctAggFunctionFactory() {
        super("TOPKDISTINCT", Arrays.asList(new KsqlAggregateFunction[0]));
    }

    @Override
    public KsqlAggregateFunction getProperAggregateFunction(List<Schema> argTypeList) {
        if (argTypeList.isEmpty()) {
            throw new KsqlException("TOPKDISTINCT function should have two arguments.");
        }
        Schema argSchema = argTypeList.get(0);
        switch (argSchema.type()) {
            case INT32: {
                return new TopkDistinctKudaf<Integer>(-1, 0, Schema.INT32_SCHEMA, Integer.class);
            }
            case INT64: {
                return new TopkDistinctKudaf<Long>(-1, 0, Schema.INT64_SCHEMA, Long.class);
            }
            case FLOAT64: {
                return new TopkDistinctKudaf<Double>(-1, 0, Schema.FLOAT64_SCHEMA, Double.class);
            }
            case STRING: {
                return new TopkDistinctKudaf<String>(-1, 0, Schema.STRING_SCHEMA, String.class);
            }
        }
        throw new KsqlException("No TOPKDISTINCT aggregate function with " + argTypeList.get(0) + " argument type exists!");
    }
}

