/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.sum;

import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.parser.tree.Expression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.streams.kstream.Merger;

public class IntegerSumKudaf
extends KsqlAggregateFunction<Integer, Integer> {
    IntegerSumKudaf(int argIndexInValue) {
        super(argIndexInValue, () -> 0, Schema.INT32_SCHEMA, Collections.singletonList(Schema.INT32_SCHEMA));
    }

    @Override
    public Integer aggregate(Integer currentVal, Integer currentAggVal) {
        if (currentVal == null) {
            return currentAggVal;
        }
        return currentVal + currentAggVal;
    }

    @Override
    public Merger<String, Integer> getMerger() {
        return (aggKey, aggOne, aggTwo) -> aggOne + aggTwo;
    }

    @Override
    public KsqlAggregateFunction<Integer, Integer> getInstance(Map<String, Integer> expressionNames, List<Expression> functionArguments) {
        int udafIndex = expressionNames.get(functionArguments.get(0).toString());
        return new IntegerSumKudaf(udafIndex);
    }
}

